% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_1comp_cl.R
\name{cp_1comp_cl}
\alias{cp_1comp_cl}
\title{Analytical 1-compartment model with specific clearance}
\usage{
cp_1comp_cl(params, time, dose, route, medium = "plasma", restrictive = FALSE)
}
\arguments{
\item{params}{A named numeric vector of model parameter values. See Details for
requirements.}

\item{time}{A numeric vector of times, reflecting the time point when
concentration is measured after the corresponding single bolus dose. Must be
same length as `dose` and `iv.dose`, or length 1.}

\item{dose}{A numeric vector of doses, reflecting single bolus doses
administered at time 0. Must be same length as `time` and `iv.dose`, or
length 1.}

\item{route}{A character vector, reflecting the route of administration of
each single bolus dose: `'oral'` or `'iv'`.  Must be same length as `time`
and `dose`, or length 1.}

\item{medium}{A character vector reflecting the medium in which each resulting
concentration is to be calculated: "blood" or "plasma". Default is "plasma".
Must be same length as `time` and `dose`, or length 1.}

\item{restrictive}{A logical value (TRUE or FALSE. Default: FALSE) that says whether the
assumption is that the clearance is restrictive or non-restrictive}
}
\value{
A vector of blood or plasma concentration values  corresponding
 to `time`.
}
\description{
Calculates plasma concentrations vs. time according to the analytical solution
for the 1-compartment model, for single bolus doses (IV and/or oral).
}
\details{
# Required parameters

`params` must include the following named items:
  \describe{
  \item{Fup}{Fraction of compound unbound in plasma. Unitless.}
  \item{Clint}{Intrinsic clearance by hepatocytes. Units: 1/hr}
  \item{Q_totli}{Total blood flow through the liver. Units: L/h/kg body weight ^ (3/4)}
  \item{Q_gfr}{Glomerular filtration rate, how quickly do kidneys filter. Units: L/h/kg body weight ^ (3/4)}
  \item{Vdist}{Apparent volume of central compartment, volume/unit BW. Or see below for
  `Fgutabs_Vdist`}
  }

For oral administration (if any `route %in% "oral"`), `params` must also
include:
  \describe{
  \item{Fgutabs}{Oral bioavailability, unitless fraction. Or see below for
  `Fgutabs_Vdist`}
  \item{kgutabs}{Rate of absorption from gut, 1/time.}
  }

For oral administration, in lieu of `Vdist` and `Fgutabs`, you may instead
provide `Fgutabs_Vdist`, the ratio of Fgutabs to Vdist (1/volume). This is an
alternate parameterization for situations where `Fgutabs` and `Vdist` are not
identifiable separately (i.e., when oral TK data are available, but IV data
are not). If `Fgutabs` and `Vdist` are provided, they will override any value
provided for `Fgutabs_Vdist`.

If both oral and IV administration are specified (i.e., some `route %in% "iv"`
and some `route %in% "oral"`), then `Vdist` is required along with either
`Fgutabs` or `Fgutabs_Vdist`. (If `Vdist` and `Fgutabs_Vdist` are provided,
but `Fgutabs` is not provided, then `Fgutabs` will be calculated from `Vdist`
and `Fgutabs_Vdist`.)

If `any(medium %in% 'blood')`, then `params` must also include
`Rblood2plasma`, the ratio of chemical concentration in whole blood to the
chemical concentration in blood plasma.
}
\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other 1-compartment model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{cp_1comp}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()}

Other model concentration functions: 
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_flat}()}
}
\author{
Caroline Ring, John Wambaugh
}
\concept{1-compartment model functions}
\concept{built-in model functions}
\concept{model concentration functions}
