% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_get_tkstats.R
\name{get_tkstats.pk}
\alias{get_tkstats.pk}
\title{Get TK stats}
\usage{
\method{get_tkstats}{pk}(
  obj,
  newdata = NULL,
  tk_group = NULL,
  model = NULL,
  method = NULL,
  exclude = TRUE,
  vol_unit = "L",
  dose_norm = TRUE,
  suppress.messages = NULL,
  ...
)
}
\arguments{
\item{obj}{A [pk()] model object. Must be fitted, or the function will exit
with an error.}

\item{newdata}{Optional: A `data.frame` containing new data for which to
compute the TK stats. Must contain at least variables `Chemical`,
`Species`, `Route`, `Media`, `Dose`, `Dose.Units`, `Conc.Units`, either
`Time_trans.Units` or `Time.Units`, and any other variables named in
`tk_grouping`. Default `NULL`, to use the data in `obj$data`.}

\item{tk_group}{A list of variables provided using a `dplyr::vars()` call.
The data (either `newdata` or `obj$data`) will be grouped according to the
unique combinations of these variables. For each unique combination of
these variables in the data, a set of TK statistics will be computed. The
default is `obj$settings_data_info$summary_group`, to derive TK statistics for
the same groups of data as non-compartmental analysis statistics. With the
default, you can directly compare e.g. a model-predicted AUC_inf to the
corresponding NCA-estimated AUC_inf. However, you may specify a different
data grouping if you wish. Each group should have a unique combination of
`Chemical`, `Species`, `Route`, `Media`, and `Dose`, because the TK stats
depend on these values, and it is required to have one unique set of TK
stats per group.}

\item{model}{Character: One or more of the models fitted. Default `NULL` to
return TK stats for all models.}

\item{method}{Character: One or more of the [optimx::optimx()] methods used.
Default `NULL` to return TK stats for all methods.}

\item{exclude}{Logical: `TRUE` to get the TK groupings after removing any
observations in the data marked for exclusion (if there is a variable
`exclude` in the data, an observation is marked for exclusion when  `TRUE`).
`FALSE` to include all observations when getting the TK
groupings, regardless of exclusion status. Default `TRUE`.}

\item{vol_unit}{Character: Specifies the unit of volume. Defaults to "L" for liters.}

\item{dose_norm}{Logical: `TRUE` (default) specifies whether the concentrations are dose-normalized.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in
`obj$settings_preprocess$suppress.messages`}

\item{...}{Additional arguments not currently in use.}
}
\value{
A data.frame with one row for each `data_group`, `model` and `method`
  with the variables in the `data.frame` returned by the `tkstats_fun` for
  its corresponding model.
  (For the built-in models `model_flat`, `model_1comp`, and `model_2comp`, these
  variables are `param_name` and `param_value`.)
}
\description{
Extract derived TK statistics from a fitted [pk()] model object.
}
\details{
After fitting model parameters (e.g. elimination rate, volume of
distribution, absorption rate, bioavailability), it can be useful to derive
summary toxicokinetic statistics such as total clearance rate, half-life,
peak concentration, AUC_inf (the area under the concentration-time curve when
time goes to infinity), etc.

Many of these TK statistics depend not only on chemical and species, but also
on route, media (tissue), and dose. Therefore, TK stats need to be computed
for a specific set of Chemical, Species, Route, Media, and Dose.

TK statistics for a defined [pk_model()] object are computed using the
function named in the model's `tkstats_fun`. For the built-in models, the
`tkstats_fun` functions are the following. See the documentation for the
individual functions for details on what TK stats are calculated for each
model, and how they are calculated.
-`model_1comp`: [tkstats_1comp()]
-`model_2comp`: [tkstats_2comp()]
-`model_flat`: [tkstats_flat()]
}
\seealso{
Other methods for fitted pk objects: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{coef_sd.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{logLik.pk}()},
\code{\link{predict.pk}()},
\code{\link{residuals.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{methods for fitted pk objects}
