% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_p_out.R
\encoding{utf-8}
\name{optimal_p_out}
\alias{optimal_p_out}
\title{Table and plot the SONE values}
\usage{
optimal_p_out(scenario_max, scenario_min, sizes, n_sim, to_min, plotting = "",
  multi = 1)
}
\arguments{
\item{scenario_max}{SONE data from \code{\link{scenario_sim}} output}

\item{scenario_min}{SONE data from \code{\link{scenario_sim}} output}

\item{sizes}{An array of sample sizes to be simulated. Can be single value.}

\item{n_sim}{number of simulations. 1000 is a start, 10000 was used in paper, but takes a long time}

\item{to_min}{How many indicators relate to the outcome in the lack of ION condition. In \code{\link{optimal_p}} defaults to (round((n_indicators/2),0)) - 1), i.e close to half the number of indicators.}

\item{plotting}{Plots the result with \code{\link{optimal_p_out}}. Defaults to ''. Possible options: '' - no plot; 'yes' - a regular plot;  'file' -- writes the plot to a tiff file in working directory. If sizes is a single value, plotting is disabled.}

\item{multi}{influences cex of certain plot variables. Defaults to 1}
}
\description{
Takes max and min scenarious and produces a table and optionally a plot.
 See \code{\link{scenario_sim}} or \code{\link{optimal_p}}.
}
\examples{
set.seed(466)
sizes=c(500,1000)
n_sim=50  #  make bigger for more accurate estimates..
to_n=8
cor_to_outcome=0.25
ptm <- proc.time()  # timing
# takes a few seconds..
scen1=scenario_sim(sizes=sizes,n_sim=n_sim,to_n=to_n, cor_to_outcome=cor_to_outcome)
proc.time() - ptm
ptm <- proc.time()
# A scenario with 3 out of 8 items relating to outcome, 3 different samples
to_n=3
scen2=scenario_sim(sizes=sizes,n_sim=n_sim,to_n=to_n, cor_to_outcome=cor_to_outcome)
proc.time() - ptm

optimal_p_out(scen1[[1]],scen2[[1]],sizes = sizes,n_sim=n_sim,to_min = to_n, plot='yes', multi=1)

# Should be equivalent. Some variation can be expected when n_sim is below 1000
ptm <- proc.time()
a=optimal_p(sizes=sizes, n_sim=n_sim, n_indicators=8, plotting='yes', cor_to_outcome=cor_to_outcome)
proc.time() - ptm
print(a[[1]])
}

