% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_cdf_diff}
\alias{compute_cdf_diff}
\title{Empirical CDF Difference}
\usage{
compute_cdf_diff(Y, f, grid, w = NULL)
}
\arguments{
\item{Y}{(matrix): n x 1 matrix of observed data.}

\item{f}{(matrix): n x 1 matrix of predictions.}

\item{grid}{(matrix): Grid of values to compute the CDF at.}

\item{w}{(vector, optional): n-vector of sample weights.}
}
\value{
(list): Difference between the empirical CDFs of the data and the
predictions and its standard deviation at the specified grid points.
}
\description{
Computes the difference between the empirical CDFs of the data and the
predictions.
}
\examples{

Y <- c(1, 2, 3, 4, 5)

f <- c(1.1, 2.2, 3.3, 4.4, 5.5)

grid <- seq(0, 6, by = 0.5)

compute_cdf_diff(Y, f, grid)

}
