% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtmodel.R
\name{drm}
\alias{drm}
\title{Dichotomous Response Model (DRM) Probabilities}
\usage{
drm(theta, a, b, g = NULL, D = 1)
}
\arguments{
\item{theta}{A vector of ability values.}

\item{a}{A vector of item discrimination (or slope) parameters.}

\item{b}{A vector of item difficulty (or threshold) parameters.}

\item{g}{A vector of item guessing parameters.}

\item{D}{A scaling factor in IRT models to make the logistic function as close as possible
to the normal ogive function (if set to 1.7). Default is 1.}
}
\value{
This function returns a matrix where a row indicates the ability and a column
represents the item.
}
\description{
This function computes the probability of correct answers for multiple items
for a given set of theta values using the IRT 1PL, 2PL, and 3PL models.
}
\details{
\code{g} does not need to be specified when the response probabilities of
the 1PL and 2PL models are computed.
}
\examples{
## when vectors are used for both theta values and item parameters (3PLM)
drm(c(-0.1, 0.0, 1.5), a = c(1, 2), b = c(0, 1), g = c(0.2, 0.1), D = 1)

## when vectors are only used for item parameters (2PLM)
drm(0.0, a = c(1, 2), b = c(0, 1), D = 1)

## when vectors are only used for theta values (3PLM)
drm(c(-0.1, 0.0, 1.5), a = 1, b = 1, g = 0.2, D = 1)

}
\seealso{
\code{\link{prm}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
