% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_others.R
\name{prop2delta}
\alias{prop2delta}
\title{Convert isotopic proportions to delta values}
\usage{
prop2delta(x = NULL, Rstandard = NULL)
}
\arguments{
\item{x}{Vector of proportions values.}

\item{Rstandard}{String describing the isotopic measurement, e.g. "d15N",
"d13C" and used to set automatically Rstandards (see the Section
"Ratios for reference standards" for more details). Alternatively, a
numeric value to use for Rstandard, e.g. 0.0036765.}
}
\value{
A vector of same length of x, containing the delta values based on
  the proportions of heavy isotope provided as x and the Rstandard provided.
}
\description{
This function performs the inverse of the operation performed by
\code{delta2prop()}.
}
\examples{
prop15N <- c(0.00395, 0.02222, 0.00462, 0.00753, NA, 0.00422, 0.00492)

# Rstandard can be specified with a string for some preset references
d15N <- prop2delta(prop15N, "d15N")
d15N

# Rstandard can also be specified manually for non-preset references
d15N_manual <- prop2delta(prop15N, 0.0036765)
d15N_manual

# Call delta2prop() to get the detail of available references
delta2prop()

}
