% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{getColorRamp}
\alias{getColorRamp}
\title{get color ramp by name, color, or function}
\usage{
getColorRamp(
  col,
  n = 15,
  trimRamp = c(0, 0),
  gradientN = 15,
  defaultBaseColor = "grey99",
  reverseRamp = FALSE,
  alpha = TRUE,
  gradientWtFactor = NULL,
  dex = 1,
  lens = 0,
  divergent = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{col}{one of the following:
\itemize{
\item \code{character} vector of two or more R colors. A color gradient
will be defined using these colors in order with \code{colorRampPalette()}.
\item \code{character} vector length=1 with one R color.
A color gradient is defined from \code{defaultBaseColor} to \code{col}
using \code{color2gradient()}. To adjust the range of light to dark
luminance, use the \code{dex} argument, where higher values increase
the range, and lower values decrease the range.
\item \code{character} vector length=1, with one recognized color ramp name:
any color palette from RColorBrewer, for example
\code{rownames(RColorBrewer::brewer.pal.info())};
any color palette function name from \code{viridisLite}.
\item \code{character} vector length=1, with one color function name,
for example \code{col="rainbow_hcl"}. Input is equivalent to supplying
one color \code{function}, see below.
\item \code{function} whose first argument expects \code{integer} number of colors
to return, for example \code{col=viridisLite::viridis} defines the function
itself as input.
\item \code{function} derived from \code{circlize::colorRamp2()},  recognized
by having attribute names \code{"breaks"} and \code{"colors"}. Note that
only the colors are used for the individual color values, not the
break points.
}}

\item{n}{\code{integer} number of output colors to return, or NULL if
the output should be a color function in the form \verb{function(n)}
which returns \code{n} colors.}

\item{trimRamp}{\code{integer} vector, expanded to length=2 as needed,
which defines the number of colors to trim from the beginning
and end of the color vector, respectively. When \code{reverseRamp=TRUE},
the colors are reversed before the trimming is applied.
If the two \code{trimRamp} values are not identical, symmetric divergent
color scales will no longer be symmetric.}

\item{gradientN}{\code{integer} number of colors to expand gradient colors
prior to trimming colors.}

\item{defaultBaseColor}{\code{character} vector indicating a color from which to
begin a color gradient, only used when col is a single color.}

\item{reverseRamp}{\code{logical} indicating whether to reverse the resulting
color ramp. This value is ignored when a single value is supplied for
col, and where "_r" or "_rev" is detected as a substring at the end
of the character value.}

\item{alpha}{\code{logical} indicating whether to honor alpha transparency
whenever \code{colorRampPalette} is called. If colors contain
no alpha transparency, this setting has no effect, otherwise the
alpha value is applied by \code{grDevices::colorRampPalette()} using
a linear gradient between each color.}

\item{gradientWtFactor}{\code{numeric} value used to expand single color
input to a gradient, using \code{color2gradient()}, prior to making
a full gradient to the \code{defaultBaseColor}.
Note that \code{dex} is the preferred method for adjusting the range
of light to dark for the given color \code{col}.}

\item{dex}{\code{numeric} darkness expansion factor, used only with input
\code{col} is a single color, which is then split into a color gradient
using \code{defaultBaseColor} by calling \code{color2gradient()}.
The \code{dex} factor adjusts the range of dark to light colors,
where higher values for \code{dex} increase the range,
making the changes more dramatic.}

\item{lens, divergent}{arguments sent to \code{warpRamp()} to
apply a warp effect to the color ramp, to compress or expand
the color gradient: \code{lens} scales the warp effect, with
positive values compressing colors toward baseline and
negative values expanding colors near baseline; \code{divergent}
is a logical indicating whether the middle color is considered
the baseline.}

\item{verbose}{\code{logical} whether to print verbose output}

\item{...}{additional arguments are ignored.}
}
\value{
\code{character} vector of R colors, or when N is NULL,
\code{function} sufficient to create R colors.
}
\description{
get color ramp by name, color, or function
}
\details{
This function accepts a color ramp name, a single color,
a vector of colors, or a function names, and returns a simple
vector of colors of the appropriate length, suitable as input
to a number of plotting functions.

When \code{n} is \code{NULL}, this function returns a color function,
wrapped by \code{grDevices::colorRampPalette()}. The colors used
are defined by \code{gradientN}, so the \code{grDevices::colorRampPalette()}
function actually uses a starting palette of \code{gradientN} number
of colors.

When \code{n} is an integer greater than \code{0}, this function returns
a vector of colors with length \code{n}.

When \code{col} is a single color value, a color gradient is created
by appending \code{defaultColorBase} to the output of
\code{color2gradient(..., n=3, gradientWtFactor=gradientWtFactor)}.
These 4 colors are used as the internal palette before
applying \code{grDevices::colorRampPalette()} as appropriate.
In this case, \code{gradientWtFactor} is used to adjust the
strength of the color gradient. The intended use is:
\code{getColorRamp("red", n=5)}. To remove the leading white
color, use \code{getColorRamp("red", n=5, trimRamp=c(1,0))}.

When \code{col} contains multiple color values, they are used
to define a color ramp directly.

When \code{col} is not a color value, it is compared to known color
palettes from \code{RColorBrewer::RColorBrewer} and \code{viridisLite},
and will use the corresponding color function or color palette.

When \code{col} refers to a color palette, the suffix \code{"_r"} may
be used to reverse the colors. For example,
\code{getColorRamp(col="RdBu_r", n=9)} will recognize the
\code{RColorBrewer} color palette \code{"RdBu"}, and will reverse the colors
to return blue to red, more suitable for heatmaps where
high values associated with heat are colored red,
and low values associated with cold are colored blue.

The argument \code{reverseRamp=TRUE} may be used to reverse the
returned colors.

Color functions from \code{viridisLite} are recognized:
\code{"viridis"}, \code{"cividis"}, \code{"inferno"}, \code{"magma"}, \code{"plasma"}.

The argument \code{trimRamp} is used to trim colors from the beginning
and end of a color ramp, respectively. This mechanism is useful
to remove the first or last color when those colors may be too
extreme. Note that internally, colors are expanded to length
\code{gradientN}, then trimmed, then the corresponding \code{n} colors
are returned.

The \code{trimRamp} argument is also useful when returning a color
function, which occurs when \code{n=NULL}. In this case, colors are
expanded to length \code{gradientN}, then are trimmed using the
values from \code{trimRamp}, then the returned function can be used
to create a color ramp of arbitrary length.

Note that when \code{reverseRamp=TRUE}, colors are reversed
before \code{trimRamp} is applied.

By default, alpha transparency will be maintained if supplied in the
input color vector. Most color ramps have no transparency, in which
case transparency can be added after the fact using \code{alpha2col()}.
}
\examples{
# get a gradient using red4
red4 <- getColorRamp("red4");
showColors(getColorRamp(red4));

# make a custom gradient
BuOr <- getColorRamp(c("dodgerblue","grey10","orange"));
showColors(BuOr);
colorList <- list(red4=red4, BuOr=BuOr);

# From RColorBrewer use a brewer name
RdBu <- getColorRamp("RdBu");
RdBu_r <- getColorRamp("RdBu_r");
colorList <- c(colorList, list(RdBu=RdBu, RdBu_r=RdBu_r));
showColors(RdBu);

if (requireNamespace("viridisLite", quietly=TRUE)) {
   viridisV <- getColorRamp("viridis");
   colorList <- c(colorList, list(viridis=viridisV));
}

# for fun, put a few color ramps onto one plot
showColors(colorList, cexCellnote=0.7);

showColors(list(`white background\ncolor='red'`=getColorRamp("red"),
   `black background\ncolor='red'`=getColorRamp("red", defaultBaseColor="black"),
   `white background\ncolor='gold'`=getColorRamp("gold"),
   `black background\ncolor='gold'`=getColorRamp("gold", defaultBaseColor="black")))

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
