% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-rowgroupmeans-madoutliers.R
\name{rowGroupMeans}
\alias{rowGroupMeans}
\alias{rowGroupRmOutliers}
\title{Calculate row group means, or other statistics}
\usage{
rowGroupMeans(
  x,
  groups,
  na.rm = TRUE,
  useMedian = TRUE,
  rmOutliers = FALSE,
  crossGroupMad = TRUE,
  madFactor = 5,
  returnType = c("output", "input"),
  rowStatsFunc = NULL,
  groupOrder = c("same", "sort"),
  keepNULLlevels = FALSE,
  includeAttributes = FALSE,
  verbose = FALSE,
  ...
)

rowGroupRmOutliers(
  x,
  groups,
  na.rm = TRUE,
  rmOutliers = TRUE,
  crossGroupMad = TRUE,
  madFactor = 5,
  returnType = c("input"),
  groupOrder = c("same", "sort"),
  keepNULLlevels = FALSE,
  includeAttributes = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{numeric} data matrix}

\item{groups}{\code{character} or \code{factor} vector of group labels,
either as a character vector, or a factor. See the parameter
\code{groupOrder} for ordering of group labels in the output
data matrix.}

\item{na.rm}{\code{logical}, default TRUE, passed to the stats func
to ignore NA values.}

\item{useMedian}{\code{logical}, default TRUE,  indicating whether the default
stat should be "mean" or "median".}

\item{rmOutliers}{\code{logical}, default FALSE, indicating whether to
apply outlier detection and removal.}

\item{crossGroupMad}{\code{logical} indicating whether to calculate
row MAD values using the median across groups for each row.
The median is calculated using non-NA and non-zero row group
MAD values. When \code{crossGroupMad=TRUE} it also calculates
the non-NA, non-zero median row MAD across all rows,
which defines the minimum difference from median applied across
all values to be considered an outlier.}

\item{madFactor}{\code{numeric} value indicating the multiple of the
MAD value to define outliers. For example \code{madFactor=5}
will take the MAD value for a group multiplied by 5,
5\emph{MAD, as a threshold for outliers. So any points more than
5}MAD distance from the median per group are outliers.}

\item{returnType}{\code{character}, default "output", the return data type:
\itemize{
\item \code{"output"} returns one summary stat value per group, per row;
\item \code{"input"} is useful when \code{rmOutliers=TRUE} in that it returns
a matrix with the same dimensions as the input, except with
outlier points replaced with NA.
}}

\item{rowStatsFunc}{\code{function}, default NULL, which takes a numeric matrix
as input, and returns a numeric vector equal to the number of
rows of the input data matrix. When supplied, \code{useMedian} is ignored.
Examples: \code{base::rowMeans()},
\code{matrixStats::rowMedians()}, \code{matrixStats::rowMads}.}

\item{groupOrder}{\code{character} string indicating how character group
labels are ordered in the final data matrix, when \code{returnType="output"}.
Note that when \code{groups} is a factor, the factor levels are kept
in that order. Otherwise, \code{"same"} keeps groups in the same
order they appear in the input matrix; \code{"sort"} applies
\code{jamba::mixedSort()} to the labels.}

\item{keepNULLlevels}{\code{logical}, default FALSE,  whether to keep factor
levels even when there are no corresponding columns in \code{x}.
When \code{TRUE} and \code{returnType="output"} the output matrix will
contain one colname for each factor level, with NA values used
to fill empty factor levels. This mechanism can be helpful to
ensure that output matrices have consistent colnames.}

\item{includeAttributes}{\code{logical}, default FALSE, whether to include
attributes with \code{"n"} number of replicates per group, and \code{"nLabel"}
with replicate label in \verb{n=#} form.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional parameters are passed to \code{rowStatsFunc},
and if \code{rmOutliers=TRUE} to \code{jamba::rowRmMadOutliers()}.}
}
\value{
\code{numeric} matrix based upon \code{returnType}:
\itemize{
\item When \code{returnType="output"} the output is a numeric matrix
with the same number of columns as the number of unique
\code{groups} labels. When \code{groups} is a factor and
\code{keepNULLlevels=TRUE}, the number of columns will be the
number of factor levels, otherwise it will be the number of
factor levels used in \code{groups}.
\item When \code{returnType="input"} the output is a numeric matrix
with the same dimensions as the input data. This output is
intended for use with \code{rmOutliers=TRUE} which will replace
outlier points with \code{NA} values. Therefore, this matrix can
be used to see the location of outliers.
}

The function also returns attributes when \code{includeAttributes=TRUE},
although the default is FALSE. The attributes describe the
number of samples per group overall:
\describe{
\item{attr(out, "n")}{The attribute \code{"n"} is used to describe
the number of replicates per group.}
\item{attr(out, "nLabel")}{The attribute \code{"nLabel"} is
a simple text label in the form \code{"n=3"}.}
}

Note that when \code{rmOutliers=TRUE} the number of replicates per
group will vary depending upon the outliers removed. In that
case, remember that the reported \code{"n"} is always the total
possible columns available prior to outlier removal.
}
\description{
Calculate row group means, or other statistics, where: \code{rowGroupMeans()}
calculates row summary stats; and \code{rowGroupRmOutliers()} is a convenience
function to call \code{rowGroupMeans(..., rmOutliers=TRUE, returnType="input")}.
}
\details{
This function by default calculates group mean values
per row in a numeric matrix. However, the stat function
can be changed to calculate row medians, row MADs, etc.

An added purpose of this function is optional outlier
filtering, via calculation of MAD values and applying
a MAD threshold cutoff. The intention is to identify
technical outliers that otherwise adversely affect the
calculated group mean or median values. To inspect the
data after outlier removal, use the parameter \code{returnType="input"}
which will return the input data matrix with \code{NA}
substituted for outlier points. Outlier detection and
removal is performed by \code{jamba::rowRmMadOutliers()}.
}
\examples{
x <- matrix(ncol=9, stats::rnorm(90));
colnames(x) <- LETTERS[1:9];
use_groups <- rep(letters[1:3], each=3)
rowGroupMeans(x, groups=use_groups)

# rowGroupRmOutliers returns the input data after outlier removal
rowGroupRmOutliers(x, groups=use_groups, returnType="input")

# rowGroupMeans(..., returnType="input") also returns the input data
rowGroupMeans(x, groups=use_groups, rmOutliers=TRUE, returnType="input")

# rowGroupMeans with outlier removal
rowGroupMeans(x, groups=use_groups, rmOutliers=TRUE)

}
\seealso{
Other jam numeric functions: 
\code{\link{deg2rad}()},
\code{\link{noiseFloor}()},
\code{\link{normScale}()},
\code{\link{rad2deg}()},
\code{\link{rowRmMadOutliers}()},
\code{\link{warpAroundZero}()}
}
\concept{jam numeric functions}
