% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{generic_smoother}
\alias{generic_smoother}
\title{generic_smoother}
\usage{
generic_smoother(mt, Ct, at, Rt, G, G.labs)
}
\arguments{
\item{mt}{matrix: A matrix containing the filtered mean of the latent states at each time. Each row should represent one variable.}

\item{Ct}{array: A 3D-array representing the filtered covariance matrix of the latent states at each time. The third dimension should represent the time index.}

\item{at}{matrix: A matrix containing the one-step-ahead mean of the latent states at each time based upon the filtered mean. Each row should represent one variable.}

\item{Rt}{array: A 3D-array representing the one-step-ahead covariance matrix of the latent states at each time based upon the filtered covariance matrix. The third dimension should represent the time index.}

\item{G}{array: A 3D-array representing the transition matrix of the model at each time.}

\item{G.labs}{matrix: A character matrix containing the type associated with each value in G.}
}
\value{
A list containing the smoothed mean (mts) and covariance (Cts) of the latent states at each time. Their dimension follows, respectively, the dimensions of mt and Ct.
}
\description{
Generic smoother for all models.
}
\details{
For the models covered in this package, we always assume that the latent states have Multivariate Normal distribution. With that assumption, we can use Kalman Smoother algorithm to calculate the posterior of the states at each time, given everything that has been observed (assuming that we already know the filtered distribution of the states).

For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.

For the details about the algorithm implemented see \insertCite{ArtigokParametrico;textual}{kDGLM}, \insertCite{Petris-DLM;textual}{kDGLM}, chapter 2, \insertCite{WestHarr-DLM;textual}{kDGLM}, chapter 4, and \insertCite{Kalman_filter_origins;textual}{kDGLM}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

\code{\link{analytic_filter}}
}
\keyword{internal}
