% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py-classes.R
\name{\%py_class\%}
\alias{\%py_class\%}
\alias{py_class}
\title{Make a python class constructor}
\usage{
spec \%py_class\% body
}
\arguments{
\item{spec}{a bare symbol \code{MyClassName}, or a call \code{MyClassName(SuperClass)}}

\item{body}{an expression that can be evaluated to construct the class
methods.}
}
\value{
The python class constructor, invisibly. Note, the same constructor is
also assigned in the parent frame.
}
\description{
Make a python class constructor
}
\examples{
\dontrun{
MyClass \%py_class\% {
  initialize <- function(x) {
    print("Hi from MyClass$initialize()!")
    self$x <- x
  }
  my_method <- function() {
    self$x
  }
}

my_class_instance <- MyClass(42)
my_class_instance$my_method()

MyClass2(MyClass) \%py_class\% {
  "This will be a __doc__ string for MyClass2"

  initialize <- function(...) {
    "This will be the __doc__ string for the MyClass2.__init__() method"
    print("Hi from MyClass2$initialize()!")
    super$initialize(...)
  }
}

my_class_instance2 <- MyClass2(42)
my_class_instance2$my_method()

reticulate::py_help(MyClass2) # see the __doc__ strings and more!

# In addition to `self`, there is also `private` available.
# This is an R environment unique to each class instance, where you can
# store objects that you don't want converted to Python, but still want
# available from methods. You can also assign methods to private, and
# `self` and `private` will be available in private methods.

MyClass \%py_class\% {

  initialize <- function(x) {
    print("Hi from MyClass$initialize()!")
    private$y <- paste("A Private field:", x)
  }

  get_private_field <- function() {
    private$y
  }

  private$a_private_method <- function() {
    cat("a_private_method() was called.\n")
    cat("private$y is ", sQuote(private$y), "\n")
  }

  call_private_method <- function()
    private$a_private_method()

  # equivalent of @property decorator in python
  an_active_property \%<-active\% function(x = NULL) {
    if(!is.null(x)) {
      cat("`an_active_property` was assigned", x, "\n")
      return(x)
    } else {
      cat("`an_active_property` was accessed\n")
      return(42)
    }
  }
}

inst1 <- MyClass(1)
inst2 <- MyClass(2)
inst1$get_private_field()
inst2$get_private_field()
inst1$call_private_method()
inst2$call_private_method()
inst1$an_active_property
inst1$an_active_property <- 11
}
}
\seealso{
\code{\link[=\%<-active\%]{\%<-active\%()}}
}
\keyword{internal}
