% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_concordance_correlation}
\alias{metric_concordance_correlation}
\title{Calculates the Concordance Correlation Coefficient (CCC).}
\usage{
metric_concordance_correlation(
  y_true,
  y_pred,
  axis = -1L,
  ...,
  name = "concordance_correlation",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor of true targets.}

\item{y_pred}{Tensor of predicted targets.}

\item{axis}{(Optional) integer or tuple of integers of the axis/axes along
which to compute the metric. Defaults to \code{-1}.}

\item{...}{For forward/backward compatability.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- mean(
  2 * (y_true - mean(y_true)) * (y_pred - mean(y_pred)) /
    (var(y_true) + var(y_pred) + (mean(y_true) - mean(y_pred))^2)
)
}\if{html}{\out{</div>}}

CCC evaluates the agreement between true values (\code{y_true}) and predicted
values (\code{y_pred}) by considering both precision and accuracy. The
coefficient ranges from -1 to 1, where a value of 1 indicates perfect
agreement.

This metric is useful in regression tasks where it is important to assess
how well the predictions match the true values, taking into account both
their correlation and proximity to the 45-degree line of perfect
concordance.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ccc <- metric_concordance_correlation(axis=-1)
y_true <- rbind(c(0, 1, 0.5),
                c(1, 1, 0.2))
y_pred <- rbind(c(0.1, 0.9, 0.5),
                c(1, 0.9, 0.2))
ccc$update_state(y_true, y_pred)
ccc$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.9816317, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model |> compile(
  optimizer = 'sgd',
  loss = 'mean_squared_error',
  metrics = c(metric_concordance_correlation())
)
}\if{html}{\out{</div>}}
}

\seealso{
Other regression metrics: \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
\concept{regression metrics}
