% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPartition.R
\name{lcModelPartition}
\alias{lcModelPartition}
\title{Create a lcModel with pre-defined partitioning}
\usage{
lcModelPartition(
  data,
  response,
  trajectoryAssignments,
  nClusters = NA,
  clusterNames = character(),
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  name = "part",
  center = meanNA,
  method = NULL,
  converged = TRUE,
  model = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{data}{A \code{data.frame} representing the trajectory data.}

\item{response}{The name of the response variable.}

\item{trajectoryAssignments}{A \code{vector} of cluster membership per trajectory, a \code{data.frame} with an id column and \code{"Cluster"} column, or the name of the cluster membership column in the \code{data} argument..
For \code{vector} input, the type must be \code{factor}, \code{character}, or \code{integer} (\code{1} to \code{nClusters}).
The order of the trajectory, and thus the respective assignments, is determined by the id column of the data.
Provide a \code{factor} id column for the input data to ensure that the ordering is as you aspect.}

\item{nClusters}{The number of clusters. Should be \code{NA} for trajectory assignments of type \code{factor}.}

\item{clusterNames}{The names of the clusters, or a function with input \code{n} outputting a \verb{character vector} of names.
If unspecified, the names are determined from the \code{trajectoryAssignments} argument.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{name}{The name of the method.}

\item{center}{The \code{function} for computing the longitudinal cluster centers, used for representing the cluster trajectories.}

\item{method}{Optional \code{lcMethod} object that was used for fitting this model to the data.}

\item{converged}{Set the converged state.}

\item{model}{An optional object to attach to the \code{lcModelPartition} object, representing the internal model that was used for obtaining the partition.}

\item{envir}{The \code{environment} associated with the model. Used for evaluating the assigned \code{data} object by \link{model.data.lcModel}.}
}
\description{
Represents an arbitrary partitioning of a set of trajectories.
As such, this model has no predictive capabilities. The cluster trajectories are represented by the specified center function (mean by default).
}
\examples{
# comparing a model to the ground truth using the adjusted Rand index
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

# extract the reference class from the Class column
trajLabels <- aggregate(Class ~ Id, head, 1, data = latrendData)
trajLabels$Cluster <- trajLabels$Class
refModel <- lcModelPartition(latrendData, response = "Y", trajectoryAssignments = trajLabels)

if (require("mclustcomp")) {
  externalMetric(model, refModel, "adjustedRand")
}
}
