% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_base.R
\name{guide_axis_base}
\alias{guide_axis_base}
\title{Custom axis guide}
\usage{
guide_axis_base(
  key = NULL,
  title = waiver(),
  theme = NULL,
  n.dodge = 1,
  check.overlap = FALSE,
  angle = waiver(),
  cap = "none",
  bidi = FALSE,
  order = 0,
  position = waiver()
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. Defaults to
\code{\link[=key_auto]{key_auto()}}. See more information in the linked topic and the 'Details'
section.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{n.dodge}{An positive \verb{<integer[1]>} setting the number of layers text
labels can occupy to avoid overlapping labels.}

\item{check.overlap}{A \verb{<logical[1]>} indicating whether to check for and
omit overlapping text. If \code{TRUE}, first, last and middle labels are
recursively prioritised in that order. If \code{FALSE}, all labels are drawn.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{cap}{A method to cap the axes. One of the following:
\itemize{
\item A \verb{<character[1]>} with one of the following:
\itemize{
\item \code{"none"} to perform no capping.
\item \code{"both"} to cap the line at both ends at the most extreme breaks.
\item \code{"upper"} to cap the line at the upper extreme break.
\item \code{"lower"} to cap the line at the lower extreme break.
}
\item A \verb{<logical>[1]}, where \code{TRUE} is equivalent to \code{"both"} and \code{FALSE}
is equivalent to \code{"none"} in the options above.
\item A sorted \verb{<numeric>[2n]} with an even number of members. The lines
will be drawn between every odd-even pair.
\item A \verb{<function>} that takes the scale's breaks as the first argument, the
scale's limits as the second argument and returns a \verb{<numeric>[2n]} as
described above.
}}

\item{bidi}{A \verb{<logical[1]>}: whether ticks should be drawn bidirectionally
(\code{TRUE}) or in a single direction (\code{FALSE}, default).}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<Guide>} object.
}
\description{
This axis guide is a visual representation of position scales and can
represent the \code{x}, \code{y}, \code{theta} and \code{r} aesthetics. It differs from
\code{\link[ggplot2:guide_axis]{guide_axis()}} in that it can accept custom keys
and is can act as an axis for \code{\link[ggplot2:coord_polar]{coord_radial()}} like
\code{\link[ggplot2:guide_axis_theta]{guide_axis_theta()}}.
}
\details{
Under the hood, this guide is a \link[=compose_stack]{stack composition} of a
\link[=primitive_line]{line}, \link[=primitive_ticks]{ticks} and
\link[=primitive_labels]{labels} primitives.

To set minor ticks, use \code{key = "minor"}, or use the \code{type} argument in
\code{key_manual()} or \code{key_map()}.

To use this as a logarithmic axis, set \code{key = "log"}.
}
\examples{
# A standard plot with custom keys
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  scale_x_continuous(
    guide = guide_axis_base(key = key_minor())
  ) +
  scale_y_continuous(
    guide = guide_axis_base(key = key_manual(c(20, 25, 30, 40)))
  )
p

# Is translated to theta axis without fuss
p + coord_radial()

# To use as logarithmic axis:
ggplot(msleep, aes(bodywt, brainwt)) +
  geom_point(na.rm = TRUE) +
  scale_x_continuous(
    transform = "log10",
    guide = guide_axis_base("log")
  )
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_nested}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
