% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-legend-base.R
\name{guide_legend_base}
\alias{guide_legend_base}
\title{Custom legend guide}
\usage{
guide_legend_base(
  key = NULL,
  title = waiver(),
  theme = NULL,
  design = NULL,
  nrow = NULL,
  ncol = NULL,
  reverse = FALSE,
  override.aes = list(),
  position = NULL,
  direction = NULL,
  order = 0
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. Defaults to
\code{\link[=key_auto]{key_auto()}}. See more information in the linked topic.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{design}{Specification of the legend layout. One of the following:
\itemize{
\item \code{NULL} (default) to use the layout algorithm of
\code{\link[ggplot2:guide_legend]{guide_legend()}}.
\item A \verb{<character[1]>} string representing a cell layout wherein \verb{#} defines
an empty cell. See examples.
\item A \verb{<matrix[n, m]>} representing a cell layout wherein \code{NA} defines an
empty cell. See examples. Non-string atomic vectors will be treated with
\code{as.matrix()}.
}}

\item{nrow, ncol}{A positive \verb{<integer[1]>} setting the desired dimensions of
the legend layout. When \code{NULL} (default), the dimensions will be derived
from the \code{design} argument or fit to match the number of keys.}

\item{reverse}{A \verb{<logical[1]>} whether the order of keys should be inverted.}

\item{override.aes}{A named \verb{<list>} specifying aesthetic parameters of the
key glyphs. See details and examples in
\code{\link[ggplot2:guide_legend]{guide_legend()}}.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}
}
\value{
A \verb{<GuideLegend>} object.
}
\description{
This legend closely mirrors \code{ggplot2::guide_legend()}, but has two
adjustments. First, \code{guide_legend_base()} supports a \code{design} argument
for a more flexible layout. Secondly, the \code{legend.spacing.y} theme element
is observed verbatim instead of overruled.
}
\examples{
# A dummy plot
p <- ggplot(data.frame(x = 1:3, type = c("tic", "tac", "toe"))) +
  aes(x, x, shape = type) +
  geom_point(na.rm = TRUE) +
  scale_shape_manual(values = c(1, 4, NA))

# A design string, each character giving a cell value.
# Newlines separate rows, white space is ignored.
design <- "
  123
  213
  321
"

# Alternatively, the same can be specified using a matrix directly
# design <- matrix(c(1, 2, 3, 2, 1, 3, 3, 2, 1), 3, 3, byrow = TRUE)

p + guides(shape = guide_legend_base(design = design))

# Empty cells can be created using `#`
design <- "
  #2#
  1#3
"

# Alternatively:
# design <- matrix(c(NA, 1, 2, NA, NA, 3), nrow = 2)

p + guides(shape = guide_legend_base(design = design))
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}

Other legend guides: 
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{legend guides}
\concept{standalone guides}
