% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-legend-cross.R
\name{guide_legend_cross}
\alias{guide_legend_cross}
\title{Cross legend guide}
\usage{
guide_legend_cross(
  key = NULL,
  title = waiver(),
  swap = FALSE,
  col_text = element_text(angle = 90, vjust = 0.5),
  override.aes = list(),
  reverse = FALSE,
  theme = NULL,
  position = NULL,
  direction = NULL,
  order = 0
)
}
\arguments{
\item{key}{One of the following key specifications:
\itemize{
\item A \link[=key_group_split]{group split} specification when using the legend to
display a compound variable like \code{paste(var1, var2)}.
\item A \link[=key_standard]{standard key} specification, like \code{\link[=key_auto]{key_auto()}}, when
crossing two separate variables across two scales.
}}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{swap}{A \verb{<logical[1]>} which when \code{TRUE} exchanges the column and row
variables in the displayed legend.}

\item{col_text}{An \verb{<element_text>} object giving adjustments to text for
the column labels. Can be \code{NULL} to display column labels in equal fashion
to the row labels.}

\item{override.aes}{A named \verb{<list>} specifying aesthetic parameters of the
key glyphs. See details and examples in
\code{\link[ggplot2:guide_legend]{guide_legend()}}.}

\item{reverse}{A \verb{<logical[2]>} whether the order of the keys should be
inverted, where the first value controls the row order and second value
the column order. Input as \verb{<logical[1]>} will be recycled.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}
}
\value{
A \verb{<GuideLegend>} object.
}
\description{
This is a legend type similar to \code{\link[ggplot2:guide_legend]{guide_legend()}}
that displays crosses, or: interactions, between two variables.
}
\examples{
# Standard use for single aesthetic. The default is to split labels to
# disentangle aesthetics that are already crossed (by e.g. `paste()`)
ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = paste(year, drv))) +
  guides(colour = "legend_cross")

# If legends should be merged between identical aesthetics, both need the
# same legend type.
ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = paste(year, drv), shape = paste(year, drv))) +
  guides(colour = "legend_cross", shape = "legend_cross")

# Crossing two aesthetics requires a shared title and `key = "auto"`. The
# easy way to achieve this is to predefine a shared guide.
my_guide <- guide_legend_cross(key = "auto", title = "My title")

ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = drv, shape = factor(year))) +
  guides(colour = my_guide, shape  = my_guide)

# You can cross more than 2 aesthetics but not more than 2 unique aesthetics.
ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = drv, shape = factor(year), size = factor(drv))) +
  scale_size_ordinal() +
  guides(colour = my_guide, shape = my_guide, size = my_guide)

# You can merge an aesthetic that is already crossed with an aesthetic that
# contributes to only one side of the cross.
ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = paste(year, drv), shape  = drv)) +
  guides(
    colour = guide_legend_cross(title = "My Title"),
    shape  = guide_legend_cross(title = "My Title", key = "auto")
  )
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_group}()}

Other legend guides: 
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_group}()}
}
\concept{legend guides}
\concept{standalone guides}
