% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-title.R
\name{primitive_title}
\alias{primitive_title}
\title{Guide primitive: title}
\usage{
primitive_title(
  title = waiver(),
  angle = waiver(),
  theme = NULL,
  position = waiver()
)
}
\arguments{
\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<PrimitiveTitle>} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a title \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide, which may differ depending on whether the guide is used in
an axis or in a legend context.
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.title.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_text>}}
for the title display.
}
}

\subsection{As a legend guide}{
\itemize{
\item \code{legend.title} an \code{\link[ggplot2:element]{<element_text>}}
for the title display.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
 geom_point()

# Adding as secondary guides
p + guides(
  x.sec = primitive_title("Horizontal Title"),
  y.sec = primitive_title(c("along vertical", "Multiple tiles"))
)
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_line}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_ticks}()}
}
\concept{primitives}
