% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R, R/methods-lgpfit.R
\docType{class}
\name{lgpfit-class}
\alias{lgpfit-class}
\alias{lgpfit}
\alias{show,lgpfit-method}
\alias{component_names,lgpfit-method}
\alias{num_components,lgpfit-method}
\alias{postproc,lgpfit-method}
\alias{contains_postproc,lgpfit-method}
\alias{clear_postproc,lgpfit-method}
\alias{get_model,lgpfit-method}
\alias{get_stanfit,lgpfit-method}
\alias{is_f_sampled,lgpfit-method}
\alias{plot,lgpfit,missing-method}
\title{An S4 class to represent the output of the \code{lgp} function}
\usage{
\S4method{show}{lgpfit}(object)

\S4method{component_names}{lgpfit}(object)

\S4method{num_components}{lgpfit}(object)

\S4method{postproc}{lgpfit}(object, verbose = TRUE)

\S4method{contains_postproc}{lgpfit}(object)

\S4method{clear_postproc}{lgpfit}(object)

\S4method{get_model}{lgpfit}(object)

\S4method{get_stanfit}{lgpfit}(object)

\S4method{is_f_sampled}{lgpfit}(object)

\S4method{plot}{lgpfit,missing}(x, y)
}
\arguments{
\item{object}{The object for which to apply a class method.}

\item{verbose}{Can the method print any messages?}

\item{x}{an \linkS4class{lgpfit} object to visualize}

\item{y}{unused argument}
}
\description{
An S4 class to represent the output of the \code{lgp} function
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(lgpfit)}: Print information and summary about the fit object.

\item \code{component_names(lgpfit)}: Get names of model components.

\item \code{num_components(lgpfit)}: Get number of model components. Returns a
positive integer.

\item \code{postproc(lgpfit)}: Apply postprocessing. Returns an updated
\linkS4class{lgpfit} object (copies data).

\item \code{contains_postproc(lgpfit)}: Check if object contains postprocessing information.

\item \code{clear_postproc(lgpfit)}: Returns an updated (copies data)
\linkS4class{lgpfit} object without any postprocessing information.

\item \code{get_model(lgpfit)}: Get the stored \linkS4class{lgpmodel} object.
Various properties of the returned object can be accessed as explained
in the documentation of \linkS4class{lgpmodel}.

\item \code{get_stanfit(lgpfit)}: Get the stored \code{\link[rstan]{stanfit}} object.
Various properties of the returned object can be accessed or plotted
as explained
\href{https://CRAN.R-project.org/package=rstan/vignettes/stanfit-objects.html}{here}
or in the documentation of \code{\link[rstan]{stanfit}}.

\item \code{is_f_sampled(lgpfit)}: Determine if inference was done by sampling
the latent signal \code{f} (and its components).

\item \code{plot(x = lgpfit, y = missing)}: Visualize parameter draws using \code{\link{plot_draws}}.

}}
\section{Slots}{

\describe{
\item{\code{stan_fit}}{An object of class \code{stanfit}.}

\item{\code{model}}{An object of class \code{lgpmodel}.}

\item{\code{num_draws}}{Total number of parameter draws.}

\item{\code{postproc_results}}{A named list containing possible postprocessing
results.}
}}

\seealso{
For extracting parameter draws, see \code{\link{get_draws}},
or the \code{rstan} methods for \code{stanfit} objects.

For more detailed plotting functions, see \code{\link{plot_draws}},
\code{\link{plot_beta}}, \code{\link{plot_warp}},
\code{\link{plot_effect_times}}
}
