% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_G_eigen}
\alias{compute_G_eigen}
\title{Compute Eigenvalues and Related Matrices for G}
\usage{
compute_G_eigen(
  X_gram,
  Lambda,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks,
  family,
  unique_penalty_per_partition,
  L_partition_list,
  keep_G = TRUE,
  shur_corrections
)
}
\arguments{
\item{X_gram}{Gram matrix list (\eqn{\textbf{X}^{T}\textbf{X}})}

\item{Lambda}{Penalty matrix (\eqn{\boldsymbol{\Lambda}})}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{parallel}{Use parallel processing}

\item{cl}{Cluster object}

\item{chunk_size}{Chunk size for parallel}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remaining chunks}

\item{family}{GLM family}

\item{unique_penalty_per_partition}{Use partition penalties}

\item{L_partition_list}{Partition penalty list (\eqn{\textbf{L}_\text{partition\_list}})}

\item{keep_G}{Return full G matrix (\eqn{\textbf{G}})}

\item{shur_corrections}{List of Shur complement corrections (\eqn{\textbf{S}})}
}
\value{
List containing combinations of:
\itemize{
  \item G - Full \eqn{\textbf{G}} matrix (if \code{keep_G=TRUE})
  \item Ghalf - \eqn{\textbf{G}^{1/2}} matrix
  \item GhalfInv - \eqn{\textbf{G}^{-1/2}} matrix (for non-identity links)
}
}
\description{
Compute Eigenvalues and Related Matrices for G
}
\details{
Computes \eqn{\textbf{G}}, \eqn{\textbf{G}^{1/2}} and \eqn{\textbf{G}^{-1/2}} matrices via eigendecomposition of \eqn{\textbf{X}^{T}\textbf{X} + \boldsymbol{\Lambda}_\text{effective} + \textbf{S}}.
Handles partition-specific penalties and parallel processing.
For non-identity link functions, also returns \eqn{\textbf{G}^{-1/2}}.
}
\keyword{internal}
