% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{maxima_detection}
\alias{maxima_detection}
\title{Local maxima extraction on image}
\usage{
maxima_detection(dem, dem.res = 1, max.width = 11, jitter = TRUE)
}
\arguments{
\item{dem}{cimg object (e.g. as created by \code{\link[imager]{cimg}}) or 
SpatRaster object (e.g. obtained with \code{\link[terra]{rast}})}

\item{dem.res}{numeric. image resolution, in case \code{dem} is a SpatRaster 
object, \code{dem.res} is extracted from the object by \code{\link[terra]{res}}}

\item{max.width}{numeric. maximum kernel width to check for local maximum, in 
pixels if \code{dem} is a cimg, in SpatRaster units otherwise}

\item{jitter}{boolean. indicates if noise should be added to image values to 
avoid adjacent maxima due to the adjacent pixels with equal values}
}
\value{
A cimg object / SpatRaster object which values correspond to the radius 
(n) in pixels / meters of the square window (width 2n+1) where the center pixel is global 
maximum (tested up to the \code{max.width} parameter)
}
\description{
Variable window size maxima detection is performed on the image to extract 
local maxima position and calculate the window size where they are global 
maxima. Gaussian white noise is added to the image to avoid adjacent maxima 
due to neighbor pixels with identical value.
}
\examples{
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)

# maxima detection
maxi <- maxima_detection(chm_chablais3)

# plot original image
terra::plot(chm_chablais3, main = "Initial image")

# plot maxima image
terra::plot(maxi, main = "Local maxima")
}
\seealso{
\code{\link{dem_filtering}}, \code{\link{maxima_selection}}, 
\code{\link{tree_segmentation}}
}
