\name{newLinkCommsAt}
\alias{newLinkCommsAt}

\title{
User-Defined Link Communities
}
\description{
This function allows the user to extract link communities by cutting the dendrogram at a specified height.
}
\usage{
newLinkCommsAt(x, cutat = 0.5)
}

\arguments{
  \item{x}{
An object of class \code{linkcomm}.
}
  \item{cutat}{
A numerical value indicating the height at which to cut the dendrogram. Defaults to 0.5.
}
}
\details{
Users may wish to explore the communities formed by cutting the dendrogram higher or lower than the maximum partition density height. After cutting at a new height, the \code{pdmax} value in the resulting object will be set to the \code{cutat} value used by the user, only to distinguish the new object from the one generated by the link communities algorithm (the global partition density maximum does not change).
}
\value{
An object of class \code{linkcomm}, which is a list containing the following components:
\item{numbers }{An integer vector with the number of edges, nodes, and communities.}
\item{hclust }{An object of class \code{\link{hclust}}, which contains information about the hierarchical clustering of links.}
\item{pdmax }{A numerical value indicating the height of the dendrogram at which the partition density is maximised.}
\item{pdens }{A numerical matrix with 2 columns; the first is the heights at which clusters appear and the second is the partition density.}
\item{nodeclusters }{A data frame consisting of 2 columns; the first contains node names, and the second contains single community IDs for each node. All communities and their nodes are represented, but not necessarily all nodes.}
\item{clusters }{A list of integer vectors containing the link IDs that belong to each community. Community IDs are the numerical position of the communities in the list.}
\item{edges }{A data frame with 3 columns; the first two contain nodes that interact with each other, and the third is an integer vector of community IDs indicating community membership for each link.}
\item{numclusters }{A named integer vector. Names are node names and integer values are the number of communities to which each node belongs.}
\item{clustsizes }{A named integer vector. Names are community IDs and integer values indicate the number of nodes that belong in each community.}
\item{igraph }{An object of class \code{\link{igraph}}. The network is represented here as an \code{igraph} object.}
\item{edgelist }{A character matrix with 2 columns containing the nodes that interact with each other.}
\item{directed }{Logical indicating whether the network is directed.}
\item{bipartite }{Logical indicating whether the network is bipartite.}
}
\references{
Kalinka, A.T. and Tomancak, P. (2011). linkcomm: an R package for the generation, visualization, and analysis of link communities in networks of arbitrary size and type. \emph{Bioinformatics} \bold{27}, 2011-2012.
}
\author{
Alex T. Kalinka \email{alex.t.kalinka@gmail.com}
}
\note{
After cutting at a new height, the \code{pdmax} value in the resulting object will be set to the \code{cutat} value used by the user, only to distinguish the new object from the one generated by the link communities algorithm (the global partition density maximum does not change).
}

\seealso{
\code{\link{getLinkCommunities}}
}
\examples{
## Generate graph and extract link communities.
g <- swiss[,3:4]
lc <- getLinkCommunities(g)

## User defined communities.
lc2 <- newLinkCommsAt(lc, cutat = 0.8)
}

