% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_indirect.R
\name{cond_indirect}
\alias{cond_indirect}
\alias{cond_indirect_effects}
\alias{indirect_effect}
\alias{cond_effects}
\alias{many_indirect_effects}
\title{Conditional, Indirect, and
Conditional Indirect Effects}
\usage{
cond_indirect(
  x,
  y,
  m = NULL,
  fit = NULL,
  est = NULL,
  implied_stats = NULL,
  wvalues = NULL,
  standardized_x = FALSE,
  standardized_y = FALSE,
  boot_ci = FALSE,
  level = 0.95,
  boot_out = NULL,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  save_boot_full = FALSE,
  prods = NULL,
  get_prods_only = FALSE,
  save_boot_out = TRUE,
  mc_ci = FALSE,
  mc_out = NULL,
  save_mc_full = FALSE,
  save_mc_out = TRUE,
  ci_out = NULL,
  save_ci_full = FALSE,
  save_ci_out = TRUE,
  ci_type = NULL,
  group = NULL,
  boot_type = c("perc", "bc")
)

cond_indirect_effects(
  wlevels,
  x,
  y,
  m = NULL,
  fit = NULL,
  w_type = "auto",
  w_method = "sd",
  sd_from_mean = NULL,
  percentiles = NULL,
  est = NULL,
  implied_stats = NULL,
  boot_ci = FALSE,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  boot_out = NULL,
  output_type = "data.frame",
  mod_levels_list_args = list(),
  mc_ci = FALSE,
  mc_out = NULL,
  ci_out = NULL,
  ci_type = NULL,
  boot_type = c("perc", "bc"),
  groups = NULL,
  ...
)

indirect_effect(
  x,
  y,
  m = NULL,
  fit = NULL,
  est = NULL,
  implied_stats = NULL,
  standardized_x = FALSE,
  standardized_y = FALSE,
  boot_ci = FALSE,
  level = 0.95,
  boot_out = NULL,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  save_boot_full = FALSE,
  save_boot_out = TRUE,
  mc_ci = FALSE,
  mc_out = NULL,
  save_mc_full = FALSE,
  save_mc_out = TRUE,
  ci_out = NULL,
  save_ci_full = FALSE,
  save_ci_out = TRUE,
  ci_type = NULL,
  boot_type = c("perc", "bc"),
  group = NULL
)

cond_effects(
  wlevels,
  x,
  y,
  m = NULL,
  fit = NULL,
  w_type = "auto",
  w_method = "sd",
  sd_from_mean = NULL,
  percentiles = NULL,
  est = NULL,
  implied_stats = NULL,
  boot_ci = FALSE,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  boot_out = NULL,
  output_type = "data.frame",
  mod_levels_list_args = list(),
  mc_ci = FALSE,
  mc_out = NULL,
  ci_out = NULL,
  ci_type = NULL,
  boot_type = c("perc", "bc"),
  groups = NULL,
  ...
)

many_indirect_effects(paths, ...)
}
\arguments{
\item{x}{Character. The name of the
predictor at the start of the path.}

\item{y}{Character. The name of the
outcome variable at the end of the
path. If the model has only one
outcome variable (e.g., moderation
only and no mediator), then this
argument can be omitted.}

\item{m}{A vector of the variable
names of the mediator(s). The path
goes from the first mediator
successively to the last mediator. If
\code{NULL}, the default, the path goes
from \code{x} to \code{y}.}

\item{fit}{The fit object. Can be a
\link[lavaan:lavaan-class]{lavaan::lavaan} object or a
list of \code{\link[=lm]{lm()}} outputs.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::lavaan.mi()}} or
its wrapper, such as \code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::sem.mi()}}.
If it is a single model fitted by
\code{\link[=lm]{lm()}}, it will be automatically converted
to a list by \code{\link[=lm2list]{lm2list()}}.}

\item{est}{The output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. If
\code{NULL}, the default, it will be
generated from \code{fit}. If supplied,
\code{fit} will be ignored.}

\item{implied_stats}{Implied means,
variances, and covariances of
observed variables, of the form of
the output of \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}}
with \code{what} set to \code{"implied"}. The
standard deviations are extracted
from this object for standardization.
Default is \code{NULL}, and implied
statistics will be computed from
\code{fit} if required.}

\item{wvalues}{A numeric vector of
named elements. The names are the
variable names of the moderators, and
the values are the values to which
the moderators will be set to.
Default is \code{NULL}.}

\item{standardized_x}{Logical.
Whether \code{x} will be standardized.
Default is \code{FALSE}. For multigroup
models, model implied standard
deviation for the selected group
will be used.}

\item{standardized_y}{Logical.
Whether \code{y} will be standardized.
Default is \code{FALSE}. For multigroup
models, model implied standard
deviation for the selected group
will be used.}

\item{boot_ci}{Logical. Whether
bootstrap confidence interval will be
formed. Default is \code{FALSE}.}

\item{level}{The level of confidence
for the bootstrap confidence
interval. Default is .95.}

\item{boot_out}{If \code{boot_ci} is
\code{TRUE}, users can supply pregenerated
bootstrap estimates. This can be the
output of \code{\link[=do_boot]{do_boot()}}. For
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, this can
be the output of a previous call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, or
\code{\link[=cond_indirect]{cond_indirect()}} with bootstrap
confidence intervals requested. These
stored estimates will be reused such
that there is no need to do
bootstrapping again. If not supplied,
the function will try to generate
them from \code{fit}.}

\item{R}{Integer. If \code{boot_ci} is
\code{TRUE}, \code{boot_out} is \code{NULL}, and
bootstrap standard errors not
requested if \code{fit} is a
\link[lavaan:lavaan-class]{lavaan::lavaan} object, this function
will do bootstrapping on \code{fit}. \code{R}
is the number of bootstrap samples.
Default is 100. For Monte Carlo
simulation, this is the number
of replications.}

\item{seed}{If bootstrapping
or Monte Carlo simulation is
conducted, this is the seed for the
bootstrapping or simulation.
Default is \code{NULL} and
seed is not set.}

\item{parallel}{Logical. If
bootstrapping is conducted, whether
parallel processing will be used.
Default is \code{TRUE}. If \code{fit} is a list
of \code{\link[=lm]{lm()}} outputs, parallel
processing will not be used.}

\item{ncores}{Integer. The number of
CPU cores to use when \code{parallel} is
\code{TRUE}. Default is the number of
non-logical cores minus one (one
minimum). Will raise an error if
greater than the number of cores
detected by
\code{\link[parallel:detectCores]{parallel::detectCores()}}. If
\code{ncores} is set, it will override
\code{make_cluster_args} in \code{\link[=do_boot]{do_boot()}}.}

\item{make_cluster_args}{A named list
of additional arguments to be passed
to \code{\link[parallel:makeCluster]{parallel::makeCluster()}}. For
advanced users. See
\code{\link[parallel:makeCluster]{parallel::makeCluster()}} for
details. Default is \code{list()}.}

\item{progress}{Logical. Display
bootstrapping progress or not.
Default is \code{TRUE}.}

\item{save_boot_full}{If \code{TRUE}, full
bootstrapping results will be stored.
Default is \code{FALSE.}}

\item{prods}{The product terms found. For internal use.}

\item{get_prods_only}{IF \code{TRUE}, will
quit early and return the product
terms found. The results can be
passed to the \code{prod} argument when
calling this function. Default is
\code{FALSE}. This function is for
internal use.}

\item{save_boot_out}{If \code{boot_out} is
supplied, whether it will be saved in
the output. Default is \code{TRUE}.}

\item{mc_ci}{Logical. Whether
Monte Carlo confidence interval will be
formed. Default is \code{FALSE}.}

\item{mc_out}{If \code{mc_ci} is
\code{TRUE}, users can supply pregenerated
Monte Carlo estimates. This can be the
output of \code{\link[=do_mc]{do_mc()}}. For
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, this can
be the output of a previous call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, or
\code{\link[=cond_indirect]{cond_indirect()}} with Monte Carlo
confidence intervals requested. These
stored estimates will be reused such
that there is no need to do
Monte Carlo simulation again. If not
supplied,
the function will try to generate
them from \code{fit}.}

\item{save_mc_full}{If \code{TRUE}, full
Monte Carlo results will be stored.
Default is \code{FALSE.}}

\item{save_mc_out}{If \code{mc_out} is
supplied, whether it will be saved in
the output. Default is \code{TRUE}.}

\item{ci_out}{If \code{ci_type} is supplied,
this is the corresponding argument.
If \code{ci_type} is \code{"boot"}, this
argument will be used as \code{boot_out}.
If \code{ci_type} is \code{"mc"}, this
argument will be used as \code{mc_out}.}

\item{save_ci_full}{If \code{TRUE}, full
bootstrapping or Monte Carlo results
will be stored.
Default is \code{FALSE.}}

\item{save_ci_out}{If either \code{mc_out}
or \code{boot_out} is
supplied, whether it will be saved in
the output. Default is \code{TRUE}.}

\item{ci_type}{The type of
confidence intervals to be formed.
Can be either \code{"boot"} (bootstrapping)
or \code{"mc"} (Monte Carlo). If not
supplied or is \code{NULL}, will check
other arguments
(e.g, \code{boot_ci} and \code{mc_ci}). If
supplied, will override \code{boot_ci}
and \code{mc_ci}.}

\item{group}{Either the group number
as appeared in the \code{\link[=summary]{summary()}}
or \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
output of a \link[lavaan:lavaan-class]{lavaan::lavaan} object,
or the group label as used in
the \link[lavaan:lavaan-class]{lavaan::lavaan} object.
Used only when the number of
groups is greater than one. Default
is \code{NULL}.}

\item{boot_type}{If bootstrap
confidence interval is to be formed,
the type of bootstrap confidence
interval. The supported types
are \code{"perc"} (percentile bootstrap
confidence interval, the default and
recommended type) and \code{"bc"}
(bias-corrected, or BC, bootstrap
confidence interval).}

\item{wlevels}{The output of
\code{\link[=merge_mod_levels]{merge_mod_levels()}}, or the
moderator(s) to be passed to
\code{\link[=mod_levels_list]{mod_levels_list()}}. If all the
moderators can be represented by one
variable, that is, each moderator is
(a) a numeric variable, (b) a
dichotomous categorical variable, or
(c) a factor or string variable used
in \code{\link[=lm]{lm()}} in \code{fit}, then it is a
vector of the names of the moderators
as appeared in the data frame. If at
least one of the moderators is a
categorical variable represented by
more than one variable, such as
user-created dummy variables used in
\code{\link[lavaan:sem]{lavaan::sem()}}, then it must be a
list of the names of the moderators,
with such moderators represented by a
vector of names. For example:
\verb{list("w1", c("gpgp2", "gpgp3")}, the
first moderator \code{w1} and the second
moderator a three-categorical
variable represented by \code{gpgp2} and
\code{gpgp3}.}

\item{w_type}{Character. Whether the
moderator is a \code{"numeric"} variable
or a \code{"categorical"} variable. If
\code{"auto"}, the function will try to
determine the type automatically.
See \code{\link[=mod_levels_list]{mod_levels_list()}} for further
information.}

\item{w_method}{Character, either
\code{"sd"} or \code{"percentile"}. If \code{"sd"},
the levels are defined by the
distance from the mean in terms of
standard deviation. if
\code{"percentile"}, the levels are
defined in percentiles.  See
\code{\link[=mod_levels_list]{mod_levels_list()}} for further
information.}

\item{sd_from_mean}{A numeric vector.
Specify the distance in standard
deviation from the mean for each
level. Default is \code{c(-1, 0, 1)} when
there is only one moderator, and
\code{c(-1, 1)} when there are more than
one moderator. Ignored if \code{w_method}
is not equal to \code{"sd"}. See
\code{\link[=mod_levels_list]{mod_levels_list()}} for further
information.}

\item{percentiles}{A numeric vector.
Specify the percentile (in
proportion) for each level. Default
is \code{c(.16, .50, .84)} if there is one
moderator, and \code{c(.16, .84)} when
there are more than one moderator.
Ignored if \code{w_method} is not equal to
\code{"percentile"}. See
\code{\link[=mod_levels_list]{mod_levels_list()}} for further
information.}

\item{output_type}{The type of output
of \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}. If
\code{"data.frame"}, the default, the
output will be converted to a data
frame. If any other values, the
output is a list of the outputs from
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{mod_levels_list_args}{Additional arguments to be passed to
\code{\link[=mod_levels_list]{mod_levels_list()}} if it is called
for creating the levels of
moderators. Default is \code{list()}.}

\item{groups}{Either a vector of
group numbers
as appeared in the \code{\link[=summary]{summary()}}
or \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
output of a \link[lavaan:lavaan-class]{lavaan::lavaan} object,
or a vector of group labels as used in
the \link[lavaan:lavaan-class]{lavaan::lavaan} object.
Used only when the number of
groups is greater than one. Default
is \code{NULL}.}

\item{...}{For \code{\link[=many_indirect_effects]{many_indirect_effects()}},
these are arguments to be passed to
\code{\link[=indirect_effect]{indirect_effect()}}.}

\item{paths}{The output of \code{\link[=all_indirect_paths]{all_indirect_paths()}}}
}
\value{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}} return an
\code{indirect}-class object.

\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} returns a
\code{cond_indirect_effects}-class object.

These two classes of objects have
their own print methods for printing
the results (see \code{\link[=print.indirect]{print.indirect()}} and \code{\link[=print.cond_indirect_effects]{print.cond_indirect_effects()}}).
They also have a \code{coef} method for
extracting the estimates
(\code{\link[=coef.indirect]{coef.indirect()}} and
\code{\link[=coef.cond_indirect_effects]{coef.cond_indirect_effects()}}) and a
\code{confint} method for extracting the
confidence intervals
(\code{\link[=confint.indirect]{confint.indirect()}} and
\code{\link[=confint.cond_indirect_effects]{confint.cond_indirect_effects()}}).
Addition and subtraction can also be
conducted on \code{indirect}-class object
to estimate and test a function of
effects (see \link{math_indirect})
}
\description{
Compute the conditional
effects, indirect effects, or
conditional indirect effects in a
structural model fitted by \code{\link[=lm]{lm()}},
\code{\link[lavaan:sem]{lavaan::sem()}}, or \code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::sem.mi()}}.
}
\details{
For a model with a mediation path
moderated by one or more moderators,
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} can be used
to compute the conditional indirect
effect from one variable to another
variable, at one or more set of
selected value(s) of the
moderator(s).

If only the effect for one set of
value(s) of the moderator(s) is
needed, \code{\link[=cond_indirect]{cond_indirect()}} can be
used.

If only the mediator(s) is/are
specified (\code{m}) and no values of
moderator(s) are specified, then the
indirect effect from one variable
(\code{x}) to another variable (\code{y}) is
computed. A convenient wrapper
\code{\link[=indirect_effect]{indirect_effect()}} can be used to
compute the indirect effect.

If only the value(s) of moderator(s)
is/are specified (\code{wvalues} or
\code{wlevels}) and no mediators (\code{m}) are
specified when calling
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} or
\code{\link[=cond_indirect]{cond_indirect()}}, then the
conditional direct effects from one
variable to another are computed.

All three functions support using
nonparametric bootstrapping (for
\code{lavaan} or \code{lm} outputs) or
Monte Carlo simulation (for
\code{lavaan} outputs only) to form
confidence intervals.
Bootstrapping or Monte Carlo
simulation only needs to be done
once. These are the possible ways to
form bootstrapping:
\enumerate{
\item Do bootstrapping or Monte Carlo
simulation in the first call
to one of these functions, by setting
\code{boot_ci} or \code{mc_ci} to \code{TRUE} and
\code{R} to the
number of bootstrap samples or
replications, \code{level}
to the level of confidence (default
.95 or 95\%), and \code{seed} to reproduce
the results (\code{parallel} and \code{ncores}
are optional for bootstrapping).
This will take some
time to run for bootstrapping. The
output will have all
bootstrap or Monte Carlo estimates
stored. This
output, whether it is from
\code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, or
\code{\link[=cond_indirect]{cond_indirect()}}, can be reused by
any of these three functions by
setting \code{boot_out} (for bootstrapping)
or \code{mc_out} (for Monte Carlo
simulation) to this output.
They will form the confidence
intervals using the stored bootstrap
or Monte Carlo
estimates.
\item Do bootstrapping using
\code{\link[=do_boot]{do_boot()}} or Monte Carlo simulation
us8ing \code{\link[=do_mc]{do_mc()}}. The output can be used
in the \code{boot_out} (for bootstrapping)
or \code{mc_out} (for Monte Carlo simulation)
argument of
\code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} and
\code{\link[=cond_indirect]{cond_indirect()}}.
\item For bootstrapping,
if \code{\link[lavaan:sem]{lavaan::sem()}} is used to fit
a model and \code{se = "boot"} is used,
\code{\link[=do_boot]{do_boot()}} can extract them to
generate a \code{boot_out}-class object
that again can be used in the
\code{boot_out} argument.
}

If \code{boot_out} or \code{mc_out}
is set, arguments such
as \code{R}, \code{seed}, and \code{parallel} will
be ignored.
\subsection{Multigroup Models}{

Since Version 0.1.14.2, support for
multigroup models has been added for models
fitted by \code{lavaan}. Both bootstrapping
and Monte Carlo confidence intervals
are supported. When used on
a multigroup model:
\itemize{
\item For \code{\link[=cond_indirect]{cond_indirect()}} and
\code{\link[=indirect_effect]{indirect_effect()}}, users need to
specify the \code{group} argument
(by number or label). When using
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, if
\code{group} is not set, all groups wil
be used and the indirect effect
in each group will be computed,
kind of treating group as a moderator.
\item For \code{\link[=many_indirect_effects]{many_indirect_effects()}},
the paths can be generated from a
multigroup models.
\item Currently, \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
does not support a multigroup model
with moderators on the path selected.
The function \code{\link[=cond_indirect]{cond_indirect()}} does
not have this limitation but users
need to manually specify the desired
value of the moderator(s).
}
}

\subsection{\code{\link[=many_indirect_effects]{many_indirect_effects()}}}{

If bootstrapping or Monte Carlo
confidence intervals are requested,
it is advised to use \code{\link[=do_boot]{do_boot()}}
first to simulate the estimates.
Nevertheless, In Version 0.1.14.9
and later versions, if \code{boot_ci}
or \code{mc_ci} is \code{TRUE} when calling
\code{\link[=many_indirect_effects]{many_indirect_effects()}} but
\code{boot_out} or \code{mc_out} is not set,
bootstrapping or simulation will
be done only once, and then the
bootstrapping or simulated estimates
will be used for all paths. This
prevents accidentally repeating the
process once for each direct path.
}
}
\section{Functions}{
\itemize{
\item \code{cond_indirect()}: Compute
conditional, indirect, or conditional
indirect effects for one set of
levels.

\item \code{cond_indirect_effects()}: Compute the
conditional effects or conditional
indirect effects for several sets of
levels of the moderator(s).

\item \code{indirect_effect()}: Compute the
indirect effect. A wrapper of
\code{\link[=cond_indirect]{cond_indirect()}}. Can be used when
there is no moderator.

\item \code{cond_effects()}: Just
an alias to \code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
a better name when a path has no
moderator.

\item \code{many_indirect_effects()}: Compute the
indirect effects along more than one paths.
It call \code{\link[=indirect_effect]{indirect_effect()}} once for
each of the path.

}}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x  + d1 * w1 + e1 * x:w1
m2 ~ a2 * x
y  ~ b1 * m1 + b2 * m2 + cp * x
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)
est <- parameterEstimates(fit)
hi_w1 <- mean(dat$w1) + sd(dat$w1)

# Examples for cond_indirect():

# Conditional effect from x to m1 when w1 is 1 SD above mean
cond_indirect(x = "x", y = "m1",
              wvalues = c(w1 = hi_w1), fit = fit)

# Direct effect from x to y (direct because no 'm' variables)
indirect_effect(x = "x", y = "y", fit = fit)

# Conditional Indirect effect from x1 through m1 to y, when w1 is 1 SD above mean
cond_indirect(x = "x", y = "y", m = "m1",
              wvalues = c(w1 = hi_w1), fit = fit)



# Examples for cond_indirect_effects():

# Create levels of w1, the moderators
w1levels <- mod_levels("w1", fit = fit)
w1levels

# Conditional effects from x to m1 when w1 is equal to each of the levels
cond_indirect_effects(x = "x", y = "m1",
                      wlevels = w1levels, fit = fit)

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is equal to each of the levels
cond_indirect_effects(x = "x", y = "y", m = "m1",
                      wlevels = w1levels, fit = fit)

# Multigroup models for cond_indirect_effects()

dat <- data_med_mg
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE,
           group = "group")

# If a model has more than one group,
# it will be used as a 'moderator'.
cond_indirect_effects(x = "x", y = "y", m = "m",
                      fit = fit)


# Multigroup model for indirect_effect()

dat <- data_med_mg
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE,
           group = "group")

# If a model has more than one group,
# the argument 'group' must be set.
ind1 <- indirect_effect(x = "x",
                        y = "y",
                        m = "m",
                        fit = fit,
                        group = "Group A")
ind1
ind2 <- indirect_effect(x = "x",
                        y = "y",
                        m = "m",
                        fit = fit,
                        group = 2)
ind2


# Examples for many_indirect_effects():

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths
# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out

# Multigroup models for many_indirect_effects()

data(data_med_complicated_mg)
mod <-
"
m11 ~ x1 + x2 + c1 + c2
m12 ~ m11 + c1 + c2
m2 ~ x1 + x2 + c1 + c2
y1 ~ m11 + m12 + x1 + x2 + c1 + c2
y2 ~ m2 + x1 + x2 + c1 + c2
"
fit <- sem(mod, data_med_complicated_mg, group = "group")
summary(fit)

paths <- all_indirect_paths(fit,
                            x = "x1",
                            y = "y1")
paths
# Indirect effect estimates for all paths in all groups
out <- many_indirect_effects(paths,
                             fit = fit)
out

}
\seealso{
\code{\link[=mod_levels]{mod_levels()}} and
\code{\link[=merge_mod_levels]{merge_mod_levels()}} for generating
levels of moderators. \link{do_boot} for
doing bootstrapping before calling
these functions.
}
