% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKSN_test.R
\name{LKSN_test}
\alias{LKSN_test}
\title{DF-type test against a change in persistence}
\usage{
LKSN_test(x, trend = c("none", "linear"), tau = 0.2, lmax = 0,
  simu = 0, M = 10000)
}
\arguments{
\item{x}{the univariate numeric vector to be investigated. Missing values are not allowed.}

\item{trend}{whether the time series exhibits a trend, \code{"none"} implies no trend and \code{"linear"} implies a linear trend.}

\item{tau}{the function tests in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature. Note that if \code{T*tau<11} the test statistic cannot be calculated.}

\item{lmax}{Maximum number of lagged differences to be included in the test regression. Default is \code{lmax=0}. Note that small sample critical values might differ for \code{lmax>0} so that simulation is recommended in this case.}

\item{simu}{whether critical values should be simulated or interpolated, \code{simu=1} means simulation, \code{simu=0} means interpolation. See details. Default is \code{simu=0}.}

\item{M}{number of replications in case critical values are simulated. Default is \code{M=10000}.}
}
\value{
Returns a matrix that consists of test statistic and critical values (corresponding to \code{alpha=0.1,0.05}) for testing against a change from I(1) to I(0), I(0) to I(1), and against a change in an unknown direction.
}
\description{
This function performs the DF-type test against a change in persistence as suggested by Leybourne, Kim, Smith, and Newbold (2003). Under the null hypothesis the time series is I(1) throughout and
under the alternative a change from either I(1) to I(0) or I(0) to I(1) has occured.
}
\details{
The critical values of the tests vary with the sample size. If \code{simu=0}, the critical values provided
are based on linear interpolation of the critical values simulated by Leybourne, Kim, Smith, and Newbold (2003). These are, however, only valid for \code{tau=0.2} and \code{lmax=0}. 
In case that non-default values are chosen for \code{tau} or \code{lmax}, it is recommended to set \code{simu=1} which means that critical values are simulated based on the given data using M replications. 
Caution, for a time series of length \code{T=100} and \code{M=10,000} replications this takes approximately thirty minutes with increasing duration for higher T or M.  
It should be noted, however, that M smaller than 10,000 make the results unreliable.
}
\examples{
set.seed(410)

# generate dummy-data
series <- c(rnorm(200), cumsum(rnorm(200)))

# test for a break in persistence
LKSN_test(series, trend="none")
}
\references{
Leybourne, S., Kim, T., Smith, V., and Newbold, P. (2003): Tests for a change in persistence against the null of difference-stationarity. Econometrics Journal, 6, pp. 291-311.
}
\seealso{
\code{\link{cusum_test}}, \code{\link{LBI_test}}, \code{\link{MR_test}}, \code{\link{ratio_test}}.
}
\author{
Janis Becker
}
