% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{id_classifications}
\alias{id_classifications}
\title{Get ID classifications of taxa}
\arguments{
\item{obj}{([taxonomy()] or [taxmap()])}

\item{sep}{(`character` of length 1) The character(s) to place between
taxon IDs}
}
\value{
`character`
}
\description{
Get classification strings of taxa in an object of type [taxonomy()] or [taxmap()]
composed of taxon IDs. Each classification is constructed by concatenating
the taxon ids of the given taxon and its supertaxa.
\preformatted{
obj$id_classifications(sep = ";")
id_classifications(obj, sep = ";")}
}
\examples{
# Get classifications of IDs for each taxon
id_classifications(ex_taxmap)

# Use a different seperator
id_classifications(ex_taxmap, sep = '|')

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data}()},
\code{\link{map_data_}()},
\code{\link{n_leaves}()},
\code{\link{n_leaves_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
