% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_exp_duration.R
\name{extend_exp_duration}
\alias{extend_exp_duration}
\title{Add cumulative count and summary stats for categories for exposure duration analysis}
\usage{
extend_exp_duration(
  outdata,
  category_section_label = NULL,
  duration_category_list = NULL,
  duration_category_labels = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_exp_duration]{prepare_exp_duration()}}.}

\item{category_section_label}{A character value of section label.
If \code{NULL}, the parameter label is used with "(cumulative)".}

\item{duration_category_list}{A list of duration category ranges.
Must be real numbers and may overlap or be mutually exclusive.
A list should be in the form of \code{list(c(low1, high1), c(low2, high2), ...)}.
If \code{NA} is included in the range, it is treated as \code{-Inf} or \code{Inf}.
The range is defined as \verb{low <= x < high} for each.}

\item{duration_category_labels}{A character vector of internal labels.
Labels to be displayed for the duration_category_list values.
Must be the same length as duration_category_list.}
}
\value{
A list of analysis raw datasets.
}
\description{
Add cumulative count and summary stats for categories for exposure duration analysis
}
\examples{
meta <- meta_sl_exposure_example()
outdata <- meta |> prepare_exp_duration()
outdata |>
  extend_exp_duration(
    duration_category_list = list(c(1, NA), c(7, NA), c(21, NA)),
    duration_category_labels = c(">=1 day", ">=7 days", ">=21 days")
  )
}
