% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomreg.R
\name{binomreg}
\alias{binomreg}
\alias{glance.binomreg}
\title{Binomial regression}
\usage{
binomreg(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  link = c("identity", "probit", "logit"),
  method = c("ml", "twosteps", "minchisq", "test"),
  start = NULL,
  robust = TRUE,
  opt = c("newton", "nr", "bfgs"),
  maxit = 100,
  trace = 0,
  check_gradient = FALSE,
  ...
)

\method{glance}{binomreg}(x, ...)
}
\arguments{
\item{formula}{a symbolic description of the model}

\item{data}{a data frame,}

\item{subset, weights, na.action, offset, contrasts}{see \code{stats::lm},}

\item{link}{one of \code{"identity"}, \code{"probit"} and "\code{logit}" to fit
respectively the linear probability, the probit and the logit
model}

\item{method}{\code{"ml"} for maximum likelihood (the only relevant
method for a regression without instrumental variables),
\code{"twosteps"} for two-steps estimator, \code{"minchisq"} for minimum
chi-squared estimator and \code{"test"} to get the exogeneity test,}

\item{start}{a vector of starting values}

\item{robust}{only when \code{method = "twosteps"}, should the robust
covariance matrix be computed?}

\item{opt}{optimization method}

\item{maxit}{maximum number of iterations}

\item{trace}{printing of intermediate result}

\item{check_gradient}{if \code{TRUE} the numeric gradient and hessian
are computed and compared to the analytical gradient and
hessian}

\item{...}{further arguments}

\item{x}{a \code{binomreg} object}
}
\value{
an object of class \code{c("binomreg", "micsr")}, see
\code{micsr::micsr} for further details
}
\description{
A unified interface for binomial regression models, including
linear probability, probit and logit models
}
\examples{
pbt <- binomreg(mode ~ cost + ivtime + ovtime, data = mode_choice, link = 'probit')
lpm <- binomreg(mode ~ cost + ivtime + ovtime, data = mode_choice, link = 'identity')
summary(pbt, vcov = "opg")
}
\keyword{models}
