% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_extract.R
\name{mid.extract}
\alias{mid.extract}
\alias{mid.encoding.scheme}
\alias{mid.frames}
\alias{mid.terms}
\alias{terms.mid}
\alias{terms.mid.importance}
\alias{formula.mid}
\alias{model.frame.mid}
\title{Extract Components from MID Models}
\usage{
mid.extract(object, component, ...)

mid.encoding.scheme(object, ...)

mid.frames(object, ...)

mid.terms(
  object,
  main.effect = TRUE,
  interaction = TRUE,
  require = NULL,
  remove = NULL,
  ...
)

\method{terms}{mid}(x, ...)

\method{terms}{mid.importance}(x, ...)

\method{formula}{mid}(x, ...)

\method{model.frame}{mid}(object, ...)
}
\arguments{
\item{object}{a "mid" object.}

\item{component}{a literal character string or name. The name of the component to extract, such as "frames", "encoding.scheme" and "terms".}

\item{...}{optional parameters to be passed to the function used to extract the component.}

\item{main.effect}{logical. If \code{FALSE}, the main effect terms are excluded.}

\item{interaction}{logical. If \code{FALSE}, the interaction terms are excluded.}

\item{require}{a character vector of variable names. The terms that are not related to any of the specified names are excluded.}

\item{remove}{a character vector of variable names. The terms that are related to at least one of the specified names are excluded.}

\item{x}{a "mid" or "mid.importance" object.}
}
\value{
\code{mid.extract()} returns the \code{component} extracted from the \code{object},
\code{mid.encoding.scheme()} returns a data frame containing the information about encoding schemes,
\code{mid.frames()} returns a list of the encoding frames,
\code{mid.terms()} returns a character vector of the term labels, and
}
\description{
\code{mid.extract()} returns a component of a MID model.
}
\examples{
data(trees, package = "datasets")
mid <- interpret(Volume ~ .^2, trees, k = 10)
mid.extract(mid, encoding.scheme)
mid.extract(mid, frames)
mid.extract(mid, Girth)
mid.extract(mid, intercept)
}
