% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mo.R
\name{domhv}
\alias{domhv}
\title{Calculate Dominated Hypervolume}
\usage{
domhv(fitnesses, nadir = 0, prefilter = TRUE, on_worse_than_nadir = "warn")
}
\arguments{
\item{fitnesses}{(\verb{numeric matrix})\cr
fitness matrix, with one row per individual and one column per objective}

\item{nadir}{(\code{numeric})\cr
Lowest fitness point up to which to calculate dominated hypervolume. May be a scalar, in which case
it is used for all dimensions, or a vector, in which case its length must match the number of dimensions.
Default 0.}

\item{prefilter}{(\code{logical(1)})\cr
Whether to make a first pass that filters out dominated individuals.
If it can be guaranteed that all individuals are non-dominated, setting this to \code{FALSE} improves performance a bit.
Otherwise the recommended value is the default \code{FALSE}.}

\item{on_worse_than_nadir}{(\code{character(1)})
Action when individuals that do not dominate the nadir are found. One of \code{"quiet"} (ignore), \code{"warn"} (give warning, default), or \code{"stop"} (throw error).}
}
\value{
\code{numeric(1)}: The dominated hypervolume of individuals in \code{fitnesses}.
}
\description{
Use Chan's algorithm (Chan, M T (2013).
\dQuote{Klee's measure problem made easy.}
In \emph{2013 IEEE 54th annual symposium on foundations of computer science}, 410--419.
IEEE.) to calculate dominated hypervolume.
}
\examples{
(fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2))

# to see the fitness matrix, use:
## plot(fitnesses, pch = as.character(1:5))

domhv(fitnesses)
}
