% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.dta.R
\name{write.dta}
\alias{write.dta}
\title{Write Stata DTA File}
\usage{
write.dta(x, file = "Stata_Data.dta", version = 14, label = NULL,
          str.thres = 2045, adjust.tz = TRUE, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame to be written in Stata, vectors are
coerced to a data frame.}

\item{file}{a character string naming a file with or without file extension
'.dta', e.g., \code{"Stata_Data.dta"} or \code{"Stata_Data"}.}

\item{version}{Stats file version to use. Supports versions 8-15.}

\item{label}{dataset label to use, or \code{NULL}. Defaults to the value
stored in the "label" attribute pf data. Must be <= 80
characters.}

\item{str.thres}{any character vector with a maximum length greater than
\code{str.thre} bytes wil be stored as a long string
\code{strL} instead of a standard string \code{str}
variable if \code{version} is greater or equal 13.}

\item{adjust.tz}{this argument controls how the timezone of date-time values
is treated when writing, see 'Details' in the
in the \code{write_dta} function in the \code{havan}
package.}

\item{check}{logical: if \code{TRUE} (default), variable attributes
specified in the argument \code{var.attr} is checked.}
}
\description{
This function writes a data frame or matrix into a Stata data file.
}
\note{
This function is a modified copy of the \code{read_dta()} function in the
\pkg{haven} package by Hadley Wickham, Evan Miller and Danny Smith (2023).
}
\examples{
\dontrun{

# Example 1: Write data frame 'mtcars' into the State data file 'mtcars.dta'
write.dta(mtcars, "mtcars.dta")
}
}
\references{
Wickham H, Miller E, Smith D (2023). \emph{haven: Import and Export 'SPSS',
'Stata' and 'SAS' Files}. R package version 2.5.3.
\url{https://CRAN.R-project.org/package=haven}
}
\seealso{
\code{\link{read.dta}}, \code{\link{write.sav}}, \code{\link{write.mplus}},
\code{\link{write.xlsx}}
}
\author{
Hadley Wickham, Evan Miller and Danny Smith
}
