% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wells.R
\docType{data}
\name{wells}
\alias{wells}
\title{MLMS Wells}
\format{
A spatial feature data frame with the following variables:
\describe{
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{coord_acy_va}}{Accuracy of latitude/longitude value, in seconds.}
\item{\code{alt_va}}{Altitude of the land surface reference point (also known as the brass cap),
in feet above the North American Vertical Datum of 1988 (NAVD 88).}
\item{\code{alt_acy_va}}{Accuracy of the altitude value, in feet.}
\item{\code{etape_cf_va}}{E-tape correction factor determined through calibration, in feet.}
\item{\code{deviation_cf_va}}{Borehole deviation correction factor, in feet.}
\item{\code{stickup_va}}{Stick-up distance,
the height of the well casing that extends above the land surface measurement point, in feet.}
\item{\code{mp_b_va}}{Distance between the top and bottom of an inflated packer seal, in feet.}
\item{\code{mp_c_va}}{Distance between the transducer plane and
the measurement port inlet valve, in feet.}
\item{\code{hole_depth_va}}{Total depth to which the hole is drilled,
measured as the distance below the land surface reference point,
in feet below land surface (ft bls).}
\item{\code{well_depth_va}}{Depth of the finished well, in ft bls.}
\item{\code{construction_dt}}{Date the well was completed.}
\item{\code{install_dt}}{Date the MLMS was installed.}
\item{\code{system_tp}}{Multiport monitoring system type.
Two versions of the Westbay System were utilized in this study: the "MP55" and the "MP38".}
\item{\code{nzones}}{Number of depth-discrete monitoring zones.}
\item{\code{nports}}{Number of measurement ports.}
\item{\code{nvisits}}{Count of field visits for pressure profiling.}
\item{\code{geometry}}{Zero-dimensional geometry containing a single point.}
}
}
\source{
The dataset originates from the USGS INL Project Office
and underwent processing using the \code{\link{read_mlms_json}} function.
}
\usage{
wells
}
\description{
A spatial dataset describing the location
of wells equipped with a Multilevel Monitoring System (MLMS)
in the U.S. Geological Survey (USGS) aquifer-monitoring network,
Idaho National Laboratory (INL), Idaho.
}
\examples{
str(wells)
}
\keyword{datasets}
