% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpLearner.R
\name{mlr_pipeops_learner}
\alias{mlr_pipeops_learner}
\alias{PipeOpLearner}
\title{Wrap a Learner into a PipeOp}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Wraps an \code{\link[mlr3:Learner]{mlr3::Learner}} into a \code{\link{PipeOp}}.

Inherits the \verb{$param_set} (and therefore \verb{$param_set$values}) from the \code{\link[mlr3:Learner]{Learner}} it is constructed from.

Using \code{\link{PipeOpLearner}}, it is possible to embed \code{\link[mlr3:Learner]{mlr3::Learner}}s into \code{\link{Graph}}s, which themselves can be
turned into Learners using \code{\link{GraphLearner}}. This way, preprocessing and ensemble methods can be included
into a machine learning pipeline which then can be handled as singular object for resampling, benchmarking
and tuning.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpLearner$new(learner, id = NULL, param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}} | \code{character(1)}
\code{\link[mlr3:Learner]{Learner}} to wrap, or a string identifying a \code{\link[mlr3:Learner]{Learner}} in the \code{\link[mlr3:mlr_learners]{mlr3::mlr_learners}} \code{\link[mlr3misc:Dictionary]{Dictionary}}.
This argument is always cloned; to access the \code{\link[mlr3:Learner]{Learner}} inside \code{PipeOpLearner} by-reference, use \verb{$learner}.\cr
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, internally defaulting to the \code{id} of the \code{\link[mlr3:Learner]{Learner}} being wrapped.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpLearner}} has one input channel named \code{"input"}, taking a \code{\link[mlr3:Task]{Task}} specific to the \code{\link[mlr3:Learner]{Learner}}
type given to \code{learner} during construction; both during training and prediction.

\code{\link{PipeOpLearner}} has one output channel named \code{"output"}, producing \code{NULL} during training and a \code{\link[mlr3:Prediction]{Prediction}} subclass
during prediction; this subclass is specific to the \code{\link[mlr3:Learner]{Learner}} type given to \code{learner} during construction.

The output during prediction is the \code{\link[mlr3:Prediction]{Prediction}} on the prediction input data, produced by the \code{\link[mlr3:Learner]{Learner}}
trained on the training input data.
}

\section{State}{

The \verb{$state} is set to the \verb{$state} slot of the \code{\link[mlr3:Learner]{Learner}} object. It is a named \code{list} with members:
\itemize{
\item \code{model} :: \code{any}\cr
Model created by the \code{\link[mlr3:Learner]{Learner}}'s \verb{$.train()} function.
\item \code{train_log} :: \code{\link[data.table:data.table]{data.table}} with columns \code{class} (\code{character}), \code{msg} (\code{character})\cr
Errors logged during training.
\item \code{train_time} :: \code{numeric(1)}\cr
Training time, in seconds.
\item \code{predict_log} :: \code{NULL} | \code{\link[data.table:data.table]{data.table}} with columns \code{class} (\code{character}), \code{msg} (\code{character})\cr
Errors logged during prediction.
\item \code{predict_time} :: \code{NULL} | \code{numeric(1)}
Prediction time, in seconds.
}
}

\section{Parameters}{

The parameters are exactly the parameters of the \code{\link[mlr3:Learner]{Learner}} wrapped by this object.
}

\section{Internals}{

The \verb{$state} is currently not updated by prediction, so the \verb{$state$predict_log} and \verb{$state$predict_time} will always be \code{NULL}.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. Read-only.
\item \code{learner_model} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. This learner contains the model if the \code{PipeOp} is trained. Read-only.
\item \code{validate} :: \code{"predefined"} or \code{NULL}\cr
This field can only be set for \code{Learner}s that have the \code{"validation"} property.
Setting the field to \code{"predefined"} means that the wrapped \code{Learner} will use the internal validation task,
otherwise it will be ignored.
Note that specifying \emph{how} the validation data is created is possible via the \verb{$validate} field of the \code{\link{GraphLearner}}.
For each \code{PipeOp} it is then only possible to either use it (\code{"predefined"}) or not use it (\code{NULL}).
Also see \code{\link{set_validate.GraphLearner}} for more information.
\item \code{internal_tuned_values} :: named \code{list()} or \code{NULL}\cr
The internally tuned values if the wrapped \code{Learner} supports internal tuning, \code{NULL} otherwise.
\item \code{internal_valid_scores} :: named \code{list()} or \code{NULL}\cr
The internal validation scores if the wrapped \code{Learner} supports internal validation, \code{NULL} otherwise.
}
}

\section{Methods}{

Methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library("mlr3")

task = tsk("iris")
learner = lrn("classif.rpart", cp = 0.1)
lrn_po = mlr_pipeops$get("learner", learner)

lrn_po$train(list(task))
lrn_po$predict(list(task))
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Meta PipeOps: 
\code{\link{mlr_pipeops_learner_cv}}
}
\concept{Meta PipeOps}
\concept{PipeOps}
