% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerBatchNLoptr.R
\name{mlr_tuners_nloptr}
\alias{mlr_tuners_nloptr}
\alias{TunerBatchNLoptr}
\title{Hyperparameter Tuning with Non-linear Optimization}
\source{
Johnson, G S (2020).
\dQuote{The NLopt nonlinear-optimization package.}
\url{https://github.com/stevengj/nlopt}.
}
\description{
Subclass for non-linear optimization (NLopt).
Calls \link[nloptr:nloptr]{nloptr::nloptr} from package \CRANpkg{nloptr}.
}
\details{
The termination conditions \code{stopval}, \code{maxtime} and \code{maxeval} of \code{\link[nloptr:nloptr]{nloptr::nloptr()}} are deactivated and replaced by the \link[bbotk:Terminator]{bbotk::Terminator} subclasses.
The x and function value tolerance termination conditions (\code{xtol_rel = 10^-4}, \code{xtol_abs = rep(0.0, length(x0))}, \code{ftol_rel = 0.0} and \code{ftol_abs = 0.0}) are still available and implemented with their package defaults.
To deactivate these conditions, set them to \code{-1}.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated with the associated sugar function \code{\link[=tnr]{tnr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tnr("nloptr")
}\if{html}{\out{</div>}}
}

\section{Logging}{

All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\section{Optimizer}{

This \link{Tuner} is based on \link[bbotk:mlr_optimizers_nloptr]{bbotk::OptimizerBatchNLoptr} which can be applied on any black box optimization problem.
See also the documentation of \href{https://bbotk.mlr-org.com/}{bbotk}.
}

\section{Parameters}{


\describe{
\item{\code{algorithm}}{\code{character(1)}}
\item{\code{eval_g_ineq}}{\verb{function()}}
\item{\code{xtol_rel}}{\code{numeric(1)}}
\item{\code{xtol_abs}}{\code{numeric(1)}}
\item{\code{ftol_rel}}{\code{numeric(1)}}
\item{\code{ftol_abs}}{\code{numeric(1)}}
\item{\code{start_values}}{\code{character(1)}\cr
Create \code{random} start values or based on \code{center} of search space? In the
latter case, it is the center of the parameters before a trafo is applied.}
}

For the meaning of the control parameters, see \code{\link[nloptr:nloptr]{nloptr::nloptr()}} and
\code{\link[nloptr:nloptr.print.options]{nloptr::nloptr.print.options()}}.

The termination conditions \code{stopval}, \code{maxtime} and \code{maxeval} of
\code{\link[nloptr:nloptr]{nloptr::nloptr()}} are deactivated and replaced by the \link[bbotk]{Terminator}
subclasses. The x and function value tolerance termination conditions
(\code{xtol_rel = 10^-4}, \code{xtol_abs = rep(0.0, length(x0))}, \code{ftol_rel = 0.0} and
\code{ftol_abs = 0.0}) are still available and implemented with their package
defaults. To deactivate these conditions, set them to \code{-1}.

}

\section{Resources}{

There are several sections about hyperparameter optimization in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
\itemize{
\item An overview of all tuners can be found on our \href{https://mlr-org.com/tuners.html}{website}.
\item Learn more about \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-tuner}{tuners}.
}

The \href{https://mlr-org.com/gallery-all-optimization.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Use the \href{https://mlr-org.com/gallery/series/2023-01-15-hyperband-xgboost/}{Hyperband} optimizer with different budget parameters.
}
}

\section{Progress Bars}{


\verb{$optimize()} supports progress bars via the package \href{https://CRAN.R-project.org/package=progressr}{\pkg{progressr}}
combined with a \link[bbotk]{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\href{https://CRAN.R-project.org/package=progress}{\pkg{progress}} as backend; enable with \code{progressr::handlers("progress")}.

}

\examples{
# Hyperparameter Optimization
\donttest{

# load learner and set search space
learner = lrn("classif.rpart",
  cp = to_tune(1e-04, 1e-1, logscale = TRUE)
)

# run hyperparameter tuning on the Palmer Penguins data set
instance = tune(
  tuner = tnr("nloptr", algorithm = "NLOPT_LN_BOBYQA"),
  task = tsk("penguins"),
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce")
)

# best performing hyperparameter configuration
instance$result

# all evaluated hyperparameter configuration
as.data.table(instance$archive)

# fit final model on complete data set
learner$param_set$values = instance$result_learner_param_vals
learner$train(tsk("penguins"))
}
}
\seealso{
Other Tuner: 
\code{\link{Tuner}},
\code{\link{mlr_tuners}},
\code{\link{mlr_tuners_cmaes}},
\code{\link{mlr_tuners_design_points}},
\code{\link{mlr_tuners_gensa}},
\code{\link{mlr_tuners_grid_search}},
\code{\link{mlr_tuners_internal}},
\code{\link{mlr_tuners_irace}},
\code{\link{mlr_tuners_random_search}}
}
\concept{Tuner}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerBatch]{mlr3tuning::TunerBatch}} -> \code{\link[mlr3tuning:TunerBatchFromOptimizerBatch]{mlr3tuning::TunerBatchFromOptimizerBatch}} -> \code{TunerBatchNLoptr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerBatchNLoptr-new}{\code{TunerBatchNLoptr$new()}}
\item \href{#method-TunerBatchNLoptr-clone}{\code{TunerBatchNLoptr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerBatchFromOptimizerBatch" data-id="optimize"><a href='../../mlr3tuning/html/TunerBatchFromOptimizerBatch.html#method-TunerBatchFromOptimizerBatch-optimize'><code>mlr3tuning::TunerBatchFromOptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchNLoptr-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchNLoptr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchNLoptr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchNLoptr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchNLoptr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchNLoptr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
