% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_to_server.R
\name{list_null}
\alias{list_null}
\title{Handle Null Values for Text to List Conversions}
\usage{
list_null(par_input = "", alt_na = NULL)
}
\arguments{
\item{par_input}{A string input, default is "".}

\item{alt_na}{If alt_na is not set to NULL (the default), then it is an
alternative string used to represent NA. Usually, this is a string such as
"NA", "NaN", etc}
}
\value{
NULL if input is NA, if input is empty, or if input is alt_na (and
alt_na is not NULL). Otherwise return a parsed list.
}
\description{
Handle Null Values for Text to List Conversions
}
\examples{
# Convert missing value to null
list_null()
list_null(NA)
list_null("na", alt_na="na")

# Convert non-missing value to list
list_null("'one' = 1, 'two' = 2, 'three' = 3")

# Convert to null when a single vector is missing
list_null("'one' = 1, 'two' = NA, 'three' = 3", alt_na = "NA")
list_null("'one' = 1, NA, 'three' = 3", alt_na = "NA")

}
