% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.modelfit}
\alias{.modelfit}
\title{Fit function when model object is given}
\usage{
.modelfit(model, data, coeffun = coef, weights, control, parm = NULL)
}
\arguments{
\item{model}{model object.}

\item{data}{data.}

\item{coeffun}{function that takes the model object and returns the coefficients.
Useful when coef() does not return all coefficients (e.g. survreg).}

\item{weights}{weights.}

\item{control}{control options from \code{ctree_control}.}

\item{parm}{which parameters should be used for instability test?}
}
\value{
A function returning a list of
\item{coefficients}{ \code{coef}. }
\item{objfun}{ \code{logLik}. }
\item{object}{ the model object. }
\item{converged}{ Did the model converge? }
\item{estfun}{ \code{estfun}. }
}
\description{
Use update function to refit model and extract info such as coef, logLik and
estfun.
}
