% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saturate.R
\name{saturate}
\alias{saturate}
\title{Modify evenness without changing hue}
\usage{
saturate(r, set, edo = 12)
}
\arguments{
\item{r}{Numeric: the relative proportion to (de)saturate the set by.
If r is set to 0, returns white;
if r = 1, returns the input set. If 0 < r < 1,
the saturation is decreased. If r > 1, the saturation is increased,
potentially to the point where the set moves past some OPTIC boundary.
If r < 0, the result is an "involution" of the set.}

\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector of same length as \code{set} (another scale on the
same hue)
}
\description{
Saturation parameterizes scale structures along a single degree of freedom
which corresponds to size of the vector from the "white" perfectly even
scale to the scale in question. Variation in a scale's saturation minimally
affects its structural properties. The function \code{saturate()} takes
in a scale and a saturation parameter (\code{r}) and returns another scale
along the same line (i.e. including the scale's hue and its scalar
involution--see "Modal Color Theory," 32).
}
\examples{
lydian <- c(0, 2, 4, 6, 7, 9, 11)
qcm_fifth <- meantone_fifth()
qcm_dia <- sort(((0:6)*qcm_fifth)\%\%12)
evenness_ratio <- evenness(qcm_dia) / evenness(lydian)
desaturated_lydian <- saturate(evenness_ratio, lydian)
desaturated_lydian
qcm_dia

ionian <- c(0, 2, 4, 5, 7, 9, 11)
involution_of_ionian <- saturate(-2, ionian)
convert(involution_of_ionian, 12, 42)
asword(ionian)
asword(involution_of_ionian)

}
