% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes_filter.R
\name{genes_top_mean}
\alias{genes_top_mean}
\title{Select Top Mean Expressed Genes}
\usage{
genes_top_mean(phyex_set, top_p = 0.99, top_k = NULL)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{top_p}{Quantile threshold for gene selection (default: 0.99). Ignored if top_k is specified.}

\item{top_k}{Absolute number of top genes to select (default: NULL). Takes precedence over top_p.}
}
\value{
Character vector of gene IDs with mean expression >= top_p quantile or top top_k genes
}
\description{
Select genes with the highest mean expression across samples.
}
\details{
This function identifies genes with the highest mean expression levels,
which are often the most reliably detected and functionally important.
}
\examples{
# Select top 1\% most expressed genes by mean
high_expr_genes <- genes_top_mean(example_phyex_set, top_p = 0.99)

# Select top 1000 most expressed genes
top_1000_genes <- genes_top_mean(example_phyex_set, top_k = 1000)

}
