% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes_filter.R
\name{genes_top_variance}
\alias{genes_top_variance}
\title{Select Top Variable Genes}
\usage{
genes_top_variance(phyex_set, top_p = 0.99, top_k = NULL)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{top_p}{Quantile threshold for gene selection (default: 0.99). Ignored if top_k is specified.}

\item{top_k}{Absolute number of top genes to select (default: NULL). Takes precedence over top_p.}
}
\value{
Character vector of gene IDs with variance >= top_p quantile or top top_k genes
}
\description{
Select genes with the highest variance across samples.
}
\details{
This function identifies genes with the highest variance across samples,
which are often the most informative for downstream analyses.
}
\examples{
# Select top 1\% most variable genes
high_var_genes <- genes_top_variance(example_phyex_set, top_p = 0.99)

# Select top 500 most variable genes
top_500_var_genes <- genes_top_variance(example_phyex_set, top_k = 500)

}
