% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbi_01_population.R
\name{tbi_01_population}
\alias{tbi_01_population}
\title{TBI-01 Populations}
\usage{
tbi_01_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  transport_disposition_col,
  evitals_06_col,
  evitals_12_col,
  evitals_16_col,
  evitals_23_col,
  evitals_26_col
)
}
\arguments{
\item{df}{A data frame or tibble containing the patient data.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name in df with the patient’s unique record ID.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column name in df with the patient’s age value.}

\item{epatient_16_col}{Column name in df with the patient’s age unit (e.g.,
years, months).}

\item{eresponse_05_col}{Column name in df with response codes for the type of
EMS call.}

\item{esituation_11_col}{Column name in df with the primary provider
impression.}

\item{esituation_12_col}{Column name in df with the secondary provider
impression.}

\item{transport_disposition_col}{Column name in df with the transport
disposition.}

\item{evitals_06_col}{Column name in df with systolic blood pressure (SBP).}

\item{evitals_12_col}{Column name in df with pulse oximetry values.}

\item{evitals_16_col}{Column name in df with ETC02 values.
values.}

\item{evitals_23_col}{Column name in df with Glasgow Coma Scale (GCS) scores.}

\item{evitals_26_col}{Column name in df with AVPU (alert, verbal, painful,
unresponsive) values.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
This function screens for potential traumatic brain injury (TBI) cases based
on specific criteria in a patient dataset. It produces a subset of the data
with calculated variables for TBI identification.
}
\examples{
# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5)

  )

  # situation table
  situation_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    esituation_11 = c(rep("S02", 3), rep("S06", 2)),
    esituation_12 = c(rep("S09.90", 2), rep("S06.0X9", 3)),
  )


  # vitals table
  vitals_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    evitals_06 = c(85, 80, 100, 90, 82),
    evitals_12 = c(95, 96, 97, 98, 99),
    evitals_16 = c(35, 36, 37, 38, 39),
    evitals_23 = rep(8, 5),
    evitals_26 = c("Verbal", "Painful", "Unresponsive", "Verbal", "Painful")
  )

  # disposition table
  disposition_table <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

# test the success of the function
  result <- tbi_01_population(patient_scene_table = patient_table,
                         response_table = response_table,
                         situation_table = situation_table,
                         vitals_table = vitals_table,
                         disposition_table = disposition_table,
                         erecord_01_col = erecord_01,
                         epatient_15_col = epatient_15,
                         epatient_16_col = epatient_16,
                         eresponse_05_col = eresponse_05,
                         esituation_11_col = esituation_11,
                         esituation_12_col = esituation_12,
                         evitals_06_col = evitals_06,
                         evitals_12_col = evitals_12,
                         evitals_16_col = evitals_16,
                         evitals_23_col = evitals_23,
                         evitals_26_col = evitals_26,
                         transport_disposition_col = edisposition_30
                     )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
