% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Franchini2012.R
\docType{data}
\name{Franchini2012}
\alias{Franchini2012}
\alias{parkinson}
\title{Network meta-analysis of treatments for Parkinson's disease}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{Study}}\tab study label \cr
\bold{\emph{Treatment1}}\tab treatment 1 \cr
\bold{\emph{y1}}\tab treatment effect arm 1 \cr
\bold{\emph{sd1}}\tab Standard deviation arm 1 \cr
\bold{\emph{n1}}\tab Sample size arm 1 \cr
\bold{\emph{Treatment2}}\tab treatment 2 \cr
\bold{\emph{y2}}\tab treatment effect arm 2 \cr
\bold{\emph{sd2}}\tab Standard deviation arm 2 \cr
\bold{\emph{n2}}\tab Sample size arm 2 \cr
\bold{\emph{Treatment3}}\tab treatment 3 \cr
\bold{\emph{y3}}\tab treatment effect arm 3 \cr
\bold{\emph{sd3}}\tab Standard deviation arm 3 \cr
\bold{\emph{n3}}\tab Sample size arm 3
}
}
\source{
Dias S, Sutton AJ, Ades AE and Welton NJ (2013):
Evidence synthesis for decision making 2: A generalized linear
modeling framework for pairwise and network meta-analysis of
randomized controlled trials.
\emph{Medical Decision Making},
\bold{33}, 607--17

Franchini AJ, Dias S, Ades AE, Jansen JP, Welton NJ (2012):
Accounting for correlation in network meta-analysis with multi-arm
trials.
\emph{Research Synthesis Methods},
\bold{3}, 142--60
}
\description{
Network meta-analysis comparing the effects of a number of
treatments for Parkinson's disease.

The data are the mean lost work-time reduction in patients given
dopamine agonists as adjunct therapy in Parkinson’s disease
(Franchini et al. 2012). The data are given as sample size, mean
and standard deviation in each trial arm. Treatments are placebo
and four active drugs. These data are used as an example in the
supplemental material of Dias et al. (2013) where placebo is coded
as 1 and the four active drugs as 2 to 5.
}
\note{
The dataset Franchini2012 is identical to dataset
\code{\link[metadat]{dat.franchini2012}} in R package \bold{metadat}.
}
\examples{
head(dat.franchini2012)

\donttest{
# Transform data from arm-based format to contrast-based format
#
pw1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = dat.franchini2012, studlab = Study)
pw1

# Conduct network meta-analysis
net1 <- netmeta(pw1)
net1

# Draw network graphs
netgraph(net1, points = TRUE, cex.points = 3, cex = 1.5,
  thickness = "se.common")
netgraph(net1, points = TRUE, cex.points = 3, cex = 1.5,
  thickness = "se.common",
  iterate = TRUE, plastic = TRUE)
netgraph(net1, points = TRUE, cex.points = 3, cex = 1.5,
  thickness = "se.common",
  iterate = TRUE, plastic = TRUE, start = "eigen")
}
}
\seealso{
\code{\link[metadat]{dat.franchini2012}},
  \code{\link[meta]{pairwise}}, \code{\link[meta]{metacont}},
  \code{\link{netmeta}}, \code{\link{netgraph.netmeta}}
}
\keyword{datasets}
