% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-codebook.R
\name{ns_write_codebook}
\alias{ns_write_codebook}
\alias{ns_write_codebook.default}
\alias{ns_write_codebook.ns_codebook_raw}
\alias{ns_write_codebook.ns_codebook}
\title{Write codebook to file}
\usage{
ns_write_codebook(codebook, path, ...)

\method{ns_write_codebook}{default}(codebook, path, ...)

\method{ns_write_codebook}{ns_codebook_raw}(codebook, path, ...)

\method{ns_write_codebook}{ns_codebook}(codebook, path, sep = "\\t", ...)
}
\arguments{
\item{codebook}{object of class ns_codebook}

\item{path}{filename or path}

\item{...}{arguments to
\code{\link[jsonlite]{write_json}} or
\code{\link[utils]{write.table}}}

\item{sep}{character. If writing text table, column delimiter.}
}
\value{
no return value. Writes a file to path.
}
\description{
Save codebook information to a
file for safe keeping. Depending
on the type of codebook (raw or tidy)
the file will either be stored as a
json-file through \code{\link[jsonlite]{write_json}}
or a text table through \code{\link[utils]{write.table}}.
}
\details{
Given the two types of codebooks, writes different
       types of files.
\describe{
\item{codebook}{ - writes a tab-separated table}
\item{codebook_raw}{ - writes a json-file}
}
}
\examples{
\dontrun{
form_id <- 1100000
my_cb <- ns_get_codebook(form_id)
ns_write_codebook(my_cb, "my/path/codebook_110000.txt")
}
}
