% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/variation.R
\docType{methods}
\name{pip}
\alias{pip}
\alias{pip-method}
\alias{pip,CompositionMatrix-method}
\title{Proportionality Index of Parts (PIP)}
\usage{
pip(x, ...)

\S4method{pip}{CompositionMatrix}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{matrix}}.
}
\description{
Computes an index of association between parts.
}
\details{
The proportionality index of parts (PIP) is based on the
\link[=variation]{variation matrix}, but maintains the range of values whithin
\eqn{(0,1)}.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Variation matrix
## (Aitchison 1986, definition 4.4)
(varia <- variation(coda))

## Cluster dendrogram
d <- as.dist(varia)
h <- hclust(d, method = "ward.D2")
plot(h)

## Heatmap
stats::heatmap(
  varia,
  distfun = stats::as.dist,
  hclustfun = function(x) stats::hclust(x, method = "ward.D2"),
  symm = TRUE,
  scale = "none"
)
}
\references{
Egozcue, J. J.. & Pawlowsky-Glahn, V. (2023). Subcompositional Coherence
and and a Novel Proportionality Index of Parts. \emph{SORT}, 47(2): 229-244.
\doi{10.57645/20.8080.02.7}.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
