% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_plr.R
\docType{methods}
\name{transform_plr}
\alias{transform_plr}
\alias{transform_plr-method}
\alias{transform_plr,CompositionMatrix-method}
\alias{transform_plr,GroupedComposition-method}
\title{Pivot Log-Ratios (PLR)}
\usage{
transform_plr(object, ...)

\S4method{transform_plr}{CompositionMatrix}(object, pivot = 1)

\S4method{transform_plr}{GroupedComposition}(object, pivot = 1)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{pivot}{An \code{\link{integer}} giving the index of the pivotal variable.}
}
\value{
A \code{\linkS4class{PLR}} object.
}
\description{
Computes PLR transformations.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Isometric log-ratio
ilr <- transform_ilr(coda)
plr <- transform_plr(coda)

## Inverse transformation
inv_ilr <- transform_inverse(ilr)
all.equal(coda, inv_ilr)

inv_plr <- transform_inverse(plr)
all.equal(coda, inv_plr)
}
\references{
Fišerová, E. & Hron, K. (2011). On the Interpretation of Orthonormal
Coordinates for Compositional Data. \emph{Mathematical Geosciences}, 43(4),
455‑468. \doi{10.1007/s11004-011-9333-x}.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Greenacre, M. J. (2021). Compositional Data Analysis. \emph{Annual Review of
Statistics and Its Application}, 8(1): 271-299.
\doi{10.1146/annurev-statistics-042720-124436}.

Hron, K., Filzmoser, P., de Caritat, P., Fišerová, E. & Gardlo, A. (2017).
Weighted Pivot Coordinates for Compositional Data and Their Application to
Geochemical Mapping. \emph{Mathematical Geosciences}, 49(6), 797-814.
\doi{10.1007/s11004-017-9684-z}.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_alr}()},
\code{\link{transform_clr}()},
\code{\link{transform_ilr}()},
\code{\link{transform_inverse}()},
\code{\link{transform_lr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
