% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{nhl_make_seasons}
\alias{nhl_make_seasons}
\title{Make a vector of seasons consumable by the API}
\usage{
nhl_make_seasons(seasons = 1950:2019)
}
\arguments{
\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}
}
\value{
\code{character()}, vector of seasons suited for the NHL API.
}
\description{
The NHL API wants seasons defined in format
\code{"YYYYZZZZ"} where \code{ZZZZ = YYYY + 1}. This is a helper to take
a vector of years in \code{"YYYY"} format and create a vector of
such seasons to be used with the API.
}
\examples{
  nhlapi:::nhl_make_seasons()
  nhlapi:::nhl_make_seasons(1995:2000)
  nhlapi:::nhl_make_seasons(c(1995, 2015))
  nhlapi:::nhl_make_seasons(c("1995", "2015"))

}
