% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{parse_damage}
\alias{parse_damage}
\title{Parse damage values}
\usage{
parse_damage(damage_vector)
}
\arguments{
\item{damage_vector}{A character vector with damage values (e.g., the \code{damage_crops}
or \code{damage_property} columns in the NOAA Storm Events data). This vector should
give numbers except for specific abbreviations specifying order of magnitude (see Details).}
}
\value{
The input vector, parsed to a numeric, with abbreviations for orders of magnitude
   appropriately interpreted (e.g., "2K" in the input vector becomes the numeric 2000 in the
   output vector).
}
\description{
Take damage values that include letters for order of magnitude (e.g., "2K" for
$2,000) and return a numeric value of damage.
}
\details{
This function parses the following abbreviations for order of magnitude:
  \itemize{
    \item{"K":}{  1,000 (thousand)}
    \item{"M":}{  1,000,000 (million)}
    \item{"B":}{  1,000,000,000 (billion)}
    \item{"T":}{  1,000,000,000,000 (trillion)}
  }
}
\examples{
damage_crops <- c("150", "2K", "3.5B", NA)
parse_damage(damage_crops)

}
