% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_inference.R
\name{control_inf}
\alias{control_inf}
\title{Control parameters for inference}
\usage{
control_inf(
  var_method = c("analytic", "bootstrap"),
  rep_type = c("subbootstrap", "auto", "JK1", "JKn", "BRR", "bootstrap", "mrbbootstrap",
    "Fay"),
  vars_selection = FALSE,
  vars_combine = FALSE,
  bias_correction = FALSE,
  num_boot = 500,
  alpha = 0.05,
  cores = 1,
  keep_boot = TRUE,
  nn_exact_se = FALSE
)
}
\arguments{
\item{var_method}{the variance method (default \code{"analytic"}).}

\item{rep_type}{the replication type for weights in the bootstrap method for variance estimation passed to \code{\link[survey:as.svrepdesign]{survey::as.svrepdesign()}}.
Default is \code{"subbootstrap"}.}

\item{vars_selection}{default \code{FALSE}; if \code{TRUE}, then the variables selection model is used.}

\item{vars_combine}{whether variables should be combined after variable selection for doubly robust estimators (default \code{FALSE})}

\item{bias_correction}{default \code{FALSE}; if \code{TRUE}, then the bias minimization estimation used during model fitting.}

\item{num_boot}{the number of iteration for bootstrap algorithms.}

\item{alpha}{significance level (default 0.05).}

\item{cores}{the number of cores in parallel computing (default 1).}

\item{keep_boot}{a logical value indicating whether statistics from bootstrap should be kept (default \code{TRUE})}

\item{nn_exact_se}{a logical value indicating whether to compute the exact
standard error estimate for \code{nn} or \code{pmm} estimator. The variance estimator for
estimation based on \code{nn} or \code{pmm} can be decomposed into three parts, with the
third computed using covariance between imputed values for units in
the probability sample using predictive matches from the non-probability sample.
In most situations this term is negligible and is very computationally
expensive so by default it is set to \code{FALSE}, but the recommended option is to
set this value to \code{TRUE} before submitting the final results.}
}
\value{
A \code{list} with selected parameters.
}
\description{
\code{control_inf} constructs a \code{list} with all necessary control parameters
for statistical inference.
}
\seealso{
\code{\link[=nonprob]{nonprob()}} -- for fitting procedure with non-probability samples.
}
