% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2m.R
\name{od.2m}
\alias{od.2m}
\title{Optimal sample allocation calculation for two-level MRTs detecting main effects}
\usage{
od.2m(
  n = NULL,
  p = NULL,
  icc = NULL,
  r12 = NULL,
  r22m = NULL,
  c1 = NULL,
  c2 = NULL,
  c1t = NULL,
  omega = NULL,
  m = NULL,
  plots = TRUE,
  plot.by = NULL,
  nlim = NULL,
  plim = NULL,
  varlim = NULL,
  nlab = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  verbose = TRUE,
  iter = 100,
  tol = 1e-10,
  q = 1,
  d = 0.1,
  power = 0.8,
  ACO = TRUE,
  d.p = c(0.1, 0.5),
  d.n = c(2, 1000),
  sig.level = 0.05,
  two.tailed = TRUE,
  Jlim = c(6, 1e+10),
  nrange = c(2, 10000),
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q.aco = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-1 units within each level 2 unit
to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22m}{The proportion of variance of site-specific treatment
effect explained by covariates.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{omega}{The standardized variance of site-specific treatment effect.}

\item{m}{Total budget, default is the total costs of sampling 60
sites.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plot.by}{Plot the variance by \code{n} and/or \code{p};
default value is plot.by = list(n = "n", p = "p").}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{nlab}{The plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{plab}{The plot label for \code{p},
default value is "Proportion Level-1 Units in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{verbose}{Logical; print the values of \code{n}
and \code{p} if TRUE, otherwise not; default value is TRUE.}

\item{iter}{Number of iterations; default value is 100.}

\item{tol}{Tolerance for convergence; default value is 1e-10.}

\item{q}{The number of covariates at level 2. Default is 1.}

\item{d}{Standardized effect size, default is 0.1.}

\item{power}{Statistical power.}

\item{ACO}{Logic. If TRUE, the function will use the ant colony
optimization (ACO) algorithm to identify optimal allocations. If FALSE,
the function will use the first-order derivative method to identify
optimal allocations. Default is TRUE.}

\item{d.p}{The initial sampling domains for p. Default is c(0.1, 0.5).}

\item{d.n}{The initial sampling domain for n. Default is c(2, 1000).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{Jlim}{The range for solving the root of level-2 sample size
(\code{J}) numerically, default value is c(6, 1e+10).}

\item{nrange}{The range of the level-1 sample size per level-2 unit
that used to exclude unreasonable values. Default value is c(2, 10000).}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is -Inf.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of power analysis for calculating required budget, default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 100.}

\item{q.aco}{Locality of the ACO search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation
    (\code{n} and \code{p}).
    The function also returns the variance of the treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    multisite randomized trials (MRTs) detecting main effects is to calculate
    the optimal sample allocation that minimize the budget to achieve a
    fixed statistical power (e.g., 80%) using the ant colony optimization (ACO)
    algorithm. Alternatively, the function can calculate the allocation that
    minimizes the variance of a treatment effect under a fixed budget,
    which is less precise than the ACO algorithm.
    The optimal design parameters include
    the level-one sample size per site (\code{n})
    and the proportion of level-one unit to be assigned to treatment (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint.
}
\examples{
# Unconstrained optimal design #---------
  myod1 <- od.2m(icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005))
  myod1$out

# Constrained optimal design with p = 0.5 #---------
  myod2 <- od.2m(icc = 0.2, omega = 0.02,
              r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005), p = 0.5)
  myod2$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.81

# Constrained optimal design with n = 5 #---------
  myod3 <- od.2m(icc = 0.2, omega = 0.02,
              r12 = 0.5, r22m = 0.5, c1 = 1, c2 = 10,
              c1t = 10, varlim = c(0, 0.005), n = 5)
  myod3$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod3)
  myre$re # RE = 0.78

# Constrained n and p, no calculation performed #---------
  myod4 <- od.2m(icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005), p = 0.5, n = 10)
  myod4$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod4)
  myre$re # RE = 0.79

}
\references{
Shen, Z., & Kelcey, B. (2022). Optimal sample
   allocation in multisite randomized trials.
   The Journal of Experimental Education, 90(3), 693-711.
   <https://doi.org/10.1080/00220973.2020.1830361>
}
