% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateCohortArgument}
\alias{validateCohortArgument}
\title{Validate a cohort table input.}
\usage{
validateCohortArgument(
  cohort,
  checkEndAfterStart = FALSE,
  checkOverlappingEntries = FALSE,
  checkMissingValues = FALSE,
  checkInObservation = FALSE,
  dropExtraColumns = FALSE,
  validation = "error",
  call = parent.frame()
)
}
\arguments{
\item{cohort}{Object to be validated as a valid cohort input.}

\item{checkEndAfterStart}{If TRUE a check that all cohort end dates come on
or after cohort start date will be performed.}

\item{checkOverlappingEntries}{If TRUE a check that no individuals have
overlapping cohort entries will be performed.}

\item{checkMissingValues}{If TRUE a check that there are no missing values in
required fields will be performed.}

\item{checkInObservation}{If TRUE a check that cohort entries are within
the individuals observation periods will be performed.}

\item{dropExtraColumns}{Whether to drop extra columns that are not the
required ones.}

\item{validation}{How to perform validation: "error", "warning".}

\item{call}{A call argument to pass to cli functions.}
}
\description{
Validate a cohort table input.
}
