% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMonotonisationConstants.R
\name{getMonotonisationConstants}
\alias{getMonotonisationConstants}
\title{Calculate the Constants for Monotonisation}
\usage{
getMonotonisationConstants(
  fun,
  lower = 0,
  upper = 1,
  argument,
  nSteps = 10^4,
  epsilon = 10^(-5),
  numberOfIterationsQ = 10^4,
  design
)
}
\arguments{
\item{fun}{The function to be made monotone.}

\item{lower}{The lower limit of the interval on which the function should be monotonised. Must be a numeric value.}

\item{upper}{The upper limit of the interval on which the function should be monotonised.}

\item{argument}{The argument in which the function should be monotonised, given as a character.}

\item{nSteps}{The number of steps to be taken when checking the function for monotonicity. Must be a numeric value. Default 10^4.}

\item{epsilon}{Maximum allowed difference between the initial and monotone integral. Must be a numeric value. Default 10^-5.}

\item{numberOfIterationsQ}{Maximum number of iterations allowed to determine each value of q. Must be a numeric value. Default 10^4.}

\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
A list containing the monotonisation constants (element \code{$qs}) and the intervals on which they must be applied, specified via minimum (element \code{qls}) and maximum (element \code{qus}).
}
\description{
Computes the constants required to make a function non-increasing on the specified interval. The output of this function is necessary to calculate the monotone optimal conditional error function.
The output object is a list that contains the intervals on which constant values are required, specified by the minimum \code{dls} and maximum \code{dus} of the interval and the respective constants, \code{qs}.
}
\references{
Brannath, W., Dreher, M., zur Verth, J., Scharpenberg, M. (2024). Optimal monotone conditional error functions. https://arxiv.org/abs/2402.00814
}
