% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_spec.R
\name{option_spec}
\alias{option_spec}
\title{Specify Option}
\usage{
option_spec(
  name,
  default = bquote(),
  desc = NULL,
  option_name = get_option_name_fn(envir),
  envvar_name = get_envvar_name_fn(envir),
  option_fn = function(value, ...) value,
  envvar_fn = envvar_eval_or_raw(),
  quoted = FALSE,
  eager = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{name}{A string representing the internal name for the option. This is
the short form \verb{<option>} used within a namespace and relates to, for
example, \verb{<package>.<option>} global R option.}

\item{default}{Either a quoted expression (if parameter \code{quote == TRUE}) or
default value for the option.  Defaults to an empty expression, indicating
that it is unset. The default value is lazily evaluated, evaluated only
when the option is first requested unless parameter \code{eager == TRUE}.}

\item{desc}{A written description of the option's effects}

\item{option_name, envvar_name}{A character value or function. If a character
value is provided it is used as the corresponding global option name or
environment variable name. If a function is provided it is provided with
the package name and internal option name to derive the global option name.
For example, provided with package \code{"mypkg"} and option \code{"myoption"}, the
function might return global option name \code{"mypkg.myoption"} or environment
variable name \code{"R_MYPKG_MYOPTION"}. Defaults to configured default
functions which fall back to \code{option_name_default} and
\code{envvar_name_default}, and can be configured using \code{set_option_name_fn}
and \code{set_envvar_name_fn}.}

\item{option_fn}{A function to use for processing an option value before
being returned from the \link{opt} accessor functions. For further details see
section "Processing Functions".}

\item{envvar_fn}{A function to use for parsing environment variable values.
Defaults to \code{envvar_eval_or_raw()}. For further details see section
"Processing Functions".}

\item{quoted}{A logical value indicating whether the \code{default} argument
should be treated as a quoted expression or as a value.}

\item{eager}{A logical value indicating whether the \code{default} argument should
be eagerly evaluated (upon call), or lazily evaluated (upon first use).
This distinction will only affect default values that rely on evaluation of
an expression, which may produce a different result depending on the
context in which it is evaluated.}

\item{envir}{An environment in which to search for an options envir object.
It is rarely necessary to use anything but the default.}
}
\value{
An \code{option_spec} object, which is a simple S3 class wrapping a list
containing these arguments.
}
\description{
An option specification outlines the various behaviors of an option. It's
default value, related global R option, and related environment variable
name, as well as a description. This information defines the operating
behavior of the option.
}
\section{Processing Functions}{
Parameters \code{option_fn} and \code{envvar_fn} allow for customizing the way values
are interpreted and processed before being returned by \code{\link{opt}} functions.
\subsection{\code{envvar_fn}}{

When a value is retrieved from an environment variable, the string value
contained in the environment variable is first processed by \code{envvar_fn}.

An \code{envvar_fn} accepts only a single positional argument, and should have a
signature such as:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{function(value)
}\if{html}{\out{</div>}}
}

\subsection{\code{option_fn}}{

Regardless of how a value is produced - either retrieved from an environment
variable, option, a stored default value or from a default provided to an
\code{\link{opt}} accessor function - it is then further processed by \code{option_fn}.

The first argument provided to \code{option_fn} will always be the retrieved
value. The remaining parameters in the signature should be considered
experimental. In addition to the value, the arguments provided to \code{\link[=opt]{opt()}},
as well as an additional \code{source} parameter from \code{\link[=opt_source]{opt_source()}} may be
used.

\strong{Stable}

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(value, ...)
}\if{html}{\out{</div>}}

\strong{Experimental}

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(value, x, default, env, ..., source)
}\if{html}{\out{</div>}}
}
}

