% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancillary.R
\name{gapless_msa}
\alias{gapless_msa}
\title{Remove Gaps in a MSA}
\usage{
gapless_msa(msa, seqtype = 'AA', df = TRUE, sfile = FALSE)
}
\arguments{
\item{msa}{input alignment.}

\item{seqtype}{the nature of the sequences: 'DNA' or 'AA'.}

\item{df}{logical. When TRUE msa should be a matrix, when FALSE msa should be a string giving the path to a fasta file containing the alignment.}

\item{sfile}{if different to FALSE, then it should be a string indicating the path to save a fasta alignment file.}
}
\value{
an alignment without gaps in form of matrix or a file containing such an alignment in fasta format.
}
\description{
Removes gaps in a given msa.
}
\details{
It should be noted that this function does not carry out the alignment itself.
}
\examples{
# Example 1:
aln <- matrix(c("A",  "P",  "G",  "W",  "-",  "-",
                "-",  "A",  "G",  "W",  "C",  "-",
                "-",  "-",  "C",  "W",  "G",  "A" ), nrow = 3, byrow =TRUE)
gapless_msa(aln)
# Example 2:
\dontrun{gapless_msa(msa(sequences = c("APGW", "AGWC", "CWGA"),
                     ids = c("a", "b", "c"))$ali)}
}
\seealso{
msa
}
