% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ons_api.R
\name{get_ons_geom}
\alias{get_ons_geom}
\title{Retrieve ONS geographies}
\usage{
get_ons_geom(ons_code, returnType = c("wkt", "geojson", "geos", "sf"))
}
\arguments{
\item{ons_code}{(character) A single ONS code representing a statistical
area.}

\item{returnType}{(character) Representation for the returned geometry.
Choose \code{'wkt'} or \code{'geojson'} to return the geometry in
Well-Known Text format or GeoJSON, respectively, \code{'geos'} to return an
object of class \code{geos} or \code{'sf'} for a Simple Features object of
class \code{sf}. Default is WKT format.}
}
\value{
The coordinates of the polygon boundary in either Well-Known Text
(WKT) format, GeoJSON format, an object of class \code{geos} or as a Simple
Features object of class \code{sf}.
}
\description{
Query the Office for National Statistics online geography resources.
}
\details{
The Office for National Statistics (ONS) maintains a source of
official geographies for the UK, such as county boundaries, electoral
wards, parishes, and census output areas. These boundaries are commonly
used for data analysis, particularly of socio-economic factors. A full list
of available ONS geographies can be found here:
\url{https://statistics.data.gov.uk:443/atlas/resource?uri=http://statistics.data.gov.uk/id/statistical-geography/K02000001}.

When returning a \code{geos} object, the coordinate reference system
attribute will be set to CRS code 84 by default and not to a full CRS
definition. The \code{sf} package must be installed in order to return an
object of class \code{sf}.

Data from the ONS are provided under the terms of the Open Government
Licence
\url{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}.
For more information, please see:
\url{https://www.ons.gov.uk/methodology/geography/licences}.
}
\examples{
\donttest{
# Retrieve geography.
geog <- get_ons_geom("E05002470")
}

}
